/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml.schema;

import com.google.common.collect.ImmutableMap;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.util.ClassUtils;

public final class AnnotationProcessorUtils {
    private static final char NEW_LINE_CHAR = '\n';
    private static final char AT_CHAR = '@';
    public static final String PARAM = "@param";

    public static <T> Class<T> classFor(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        try {
            return ClassUtils.loadClass((String)processingEnvironment.getElementUtils().getBinaryName(typeElement).toString(), typeElement.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private AnnotationProcessorUtils() {
    }

    public static Set<TypeElement> getTypeElementsAnnotatedWith(Class<? extends Annotation> annotationType, RoundEnvironment roundEnvironment) {
        return ElementFilter.typesIn(roundEnvironment.getElementsAnnotatedWith(annotationType));
    }

    static Map<String, ExecutableElement> getOperationMethods(RoundEnvironment roundEnvironment) {
        ImmutableMap.Builder methods = ImmutableMap.builder();
        for (Element element : roundEnvironment.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            methods.putAll(AnnotationProcessorUtils.getMethodsAnnotatedWith((TypeElement)element, Operation.class));
        }
        return methods.build();
    }

    static Map<String, VariableElement> getFieldsAnnotatedWith(TypeElement typeElement, Class<? extends Annotation> annotation) {
        return AnnotationProcessorUtils.collectAnnotatedElements(ElementFilter.fieldsIn(typeElement.getEnclosedElements()), annotation);
    }

    static Map<String, ExecutableElement> getMethodsAnnotatedWith(TypeElement typeElement, Class<? extends Annotation> annotation) {
        return AnnotationProcessorUtils.collectAnnotatedElements(ElementFilter.methodsIn(typeElement.getEnclosedElements()), annotation);
    }

    private static <T extends Element> Map<String, T> collectAnnotatedElements(Iterable<T> elements, Class<? extends Annotation> annotation) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Element element : elements) {
            if (element.getAnnotation(annotation) == null) continue;
            fields.put((Object)element.getSimpleName().toString(), (Object)element);
        }
        return fields.build();
    }

    static MethodDocumentation getMethodDocumentation(ProcessingEnvironment processingEnv, Element element) {
        final StringBuilder parsedComment = new StringBuilder();
        final HashMap<String, String> parameters = new HashMap<String, String>();
        AnnotationProcessorUtils.parseJavaDoc(processingEnv, element, new JavadocParseHandler(){

            @Override
            void onParam(String param) {
                AnnotationProcessorUtils.parseMethodParameter(parameters, param);
            }

            @Override
            void onBodyLine(String bodyLine) {
                parsedComment.append(bodyLine).append('\n');
            }
        });
        AnnotationProcessorUtils.parseOperationParameterGroups(processingEnv, (Symbol.MethodSymbol)element, parameters);
        return new MethodDocumentation(AnnotationProcessorUtils.stripTags(parsedComment.toString()), parameters);
    }

    private static void parseOperationParameterGroups(ProcessingEnvironment processingEnv, Symbol.MethodSymbol methodElement, Map<String, String> parameterDocs) {
        for (Symbol.VarSymbol parameterSymbol : methodElement.getParameters()) {
            for (Attribute.Compound compound : parameterSymbol.getAnnotationMirrors()) {
                Class annotationClass;
                DeclaredType annotationType = compound.getAnnotationType();
                if (annotationType == null || !ParameterGroup.class.isAssignableFrom(annotationClass = AnnotationProcessorUtils.classFor((TypeElement)compound.getAnnotationType().asElement(), processingEnv))) continue;
                try {
                    AnnotationProcessorUtils.getOperationParameterGroupDocumentation((TypeElement)processingEnv.getTypeUtils().asElement(parameterSymbol.asType()), parameterDocs, processingEnv);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void getOperationParameterGroupDocumentation(TypeElement groupElement, final Map<String, String> parameterDocs, ProcessingEnvironment processingEnvironment) {
        for (final Map.Entry<String, VariableElement> entry : AnnotationProcessorUtils.getFieldsAnnotatedWith(groupElement, Parameter.class).entrySet()) {
            AnnotationProcessorUtils.parseJavaDoc(processingEnvironment, entry.getValue(), new JavadocParseHandler(){

                @Override
                void onParam(String param) {
                }

                @Override
                void onBodyLine(String bodyLine) {
                    parameterDocs.put(entry.getKey(), bodyLine);
                }
            });
        }
        for (VariableElement variableElement : AnnotationProcessorUtils.getFieldsAnnotatedWith(groupElement, ParameterGroup.class).values()) {
            AnnotationProcessorUtils.getOperationParameterGroupDocumentation((TypeElement)processingEnvironment.getTypeUtils().asElement(variableElement.asType()), parameterDocs, processingEnvironment);
        }
    }

    static String getJavaDocSummary(ProcessingEnvironment processingEnv, Element element) {
        final StringBuilder parsedComment = new StringBuilder();
        AnnotationProcessorUtils.parseJavaDoc(processingEnv, element, new JavadocParseHandler(){

            @Override
            void onParam(String param) {
            }

            @Override
            void onBodyLine(String bodyLine) {
                parsedComment.append(bodyLine).append('\n');
            }
        });
        return AnnotationProcessorUtils.stripTags(parsedComment.toString());
    }

    private static String stripTags(String comment) {
        StringBuilder builder = new StringBuilder();
        boolean insideTag = false;
        comment = comment.trim();
        int length = comment.length();
        for (int i = 0; i < length; ++i) {
            if (comment.charAt(i) == '{') {
                int nextCharIndex = i + 1;
                if (nextCharIndex < length && comment.charAt(nextCharIndex) == '@') {
                    insideTag = true;
                    i = nextCharIndex;
                    continue;
                }
            } else if (comment.charAt(i) == '}' && insideTag) {
                insideTag = false;
                continue;
            }
            builder.append(comment.charAt(i));
        }
        String strippedComments = builder.toString().trim();
        while (strippedComments.length() > 0 && strippedComments.charAt(strippedComments.length() - 1) == '\n') {
            strippedComments = StringUtils.chomp((String)strippedComments);
        }
        return strippedComments;
    }

    private static void parseJavaDoc(ProcessingEnvironment processingEnv, Element element, JavadocParseHandler handler) {
        String comment = AnnotationProcessorUtils.extractJavadoc(processingEnv, element);
        StringTokenizer st = new StringTokenizer(comment, "\n\r");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.startsWith(PARAM)) {
                handler.onParam(nextToken);
                continue;
            }
            if (nextToken.charAt(0) == '@') continue;
            handler.onBodyLine(nextToken);
        }
    }

    private static void parseMethodParameter(Map<String, String> parameters, String param) {
        param = param.replaceFirst(PARAM, "").trim();
        int descriptionIndex = param.indexOf(" ");
        String paramName = param.substring(0, descriptionIndex).trim();
        String description = param.substring(descriptionIndex).trim();
        parameters.put(paramName, description);
    }

    private static String extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (StringUtils.isBlank((String)comment)) {
            return "";
        }
        return comment.trim();
    }

    private static abstract class JavadocParseHandler {
        private JavadocParseHandler() {
        }

        abstract void onParam(String var1);

        abstract void onBodyLine(String var1);
    }
}

