/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ComponentLocation;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.dsl.api.component.AnnotatedObjectFactory;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public abstract class AbstractAnnotatedObjectFactory<T>
implements AnnotatedObjectFactory<T> {
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public final Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public org.mule.runtime.api.component.ComponentIdentifier getIdentifier() {
        return new org.mule.runtime.api.component.ComponentIdentifier(){

            public String getNamespace() {
                return ((ComponentIdentifier)AbstractAnnotatedObjectFactory.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getNamespace();
            }

            public String getName() {
                return ((ComponentIdentifier)AbstractAnnotatedObjectFactory.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getName();
            }

            public ComponentIdentifier.ComponentType getComponentType() {
                return null;
            }
        };
    }

    public ComponentLocation getLocation(final String flowPath) {
        if (flowPath == null) {
            return null;
        }
        return new ComponentLocation(){

            public String getPath() {
                return flowPath;
            }

            public Optional<String> getFileName() {
                return Optional.of((String)AbstractAnnotatedObjectFactory.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName")));
            }

            public Optional<Integer> getLineInFile() {
                return Optional.of(Integer.valueOf((Integer)AbstractAnnotatedObjectFactory.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine"))));
            }
        };
    }

    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }

    @Override
    public T getObject() throws Exception {
        Object annotatedInstance = this.doGetObject();
        if (annotatedInstance instanceof AnnotatedObject) {
            ((AnnotatedObject)annotatedInstance).setAnnotations(this.getAnnotations());
        }
        return annotatedInstance;
    }
}

