/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentConfiguration {
    private String namespace;
    private String identifier;
    private Map<String, String> parameters = new HashMap<String, String>();
    private List<ComponentConfiguration> nestedComponentConfiguration = new ArrayList<ComponentConfiguration>();
    private String textContent;

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public List<ComponentConfiguration> getNestedComponentConfiguration() {
        return Collections.unmodifiableList(this.nestedComponentConfiguration);
    }

    private ComponentConfiguration() {
    }

    public static class Builder {
        private ComponentConfiguration componentConfiguration = new ComponentConfiguration();

        public Builder setNamespace(String namespace) {
            this.componentConfiguration.namespace = namespace;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.componentConfiguration.identifier = identifier;
            return this;
        }

        public Builder addParameter(String name, String value) {
            this.componentConfiguration.parameters.put(name, value);
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.componentConfiguration.textContent = textContent;
            return this;
        }

        public Builder addNestedConfiguration(ComponentConfiguration componentConfiguration) {
            componentConfiguration.nestedComponentConfiguration.add(componentConfiguration);
            return this;
        }

        public ComponentConfiguration build() {
            return this.componentConfiguration;
        }
    }
}

