/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import com.google.common.base.Preconditions;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;

public class ComponentIdentifier {
    public static QName ANNOTATION_NAME = new QName("config", "componentIdentifier");
    private String namespace;
    private String identifier;

    private ComponentIdentifier() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.identifier;
    }

    public static ComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)componentIdentifier) ? 1 : 0) != 0, (Object)"identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = "mule";
            identifier = values[0];
        }
        return new Builder().withNamespace(namespace).withName(identifier).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentIdentifier that = (ComponentIdentifier)o;
        if (!this.namespace.equalsIgnoreCase(that.namespace)) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.namespace.toLowerCase().hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        return this.getNamespace().equals("mule") ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static class Builder {
        private ComponentIdentifier componentIdentifier = new ComponentIdentifier();

        public Builder withNamespace(String namespace) {
            this.componentIdentifier.namespace = namespace;
            return this;
        }

        public Builder withName(String identifier) {
            this.componentIdentifier.identifier = identifier;
            return this;
        }

        public ComponentIdentifier build() {
            Preconditions.checkState((this.componentIdentifier.namespace != null ? 1 : 0) != 0, (Object)"Namespace must be not null");
            Preconditions.checkState((this.componentIdentifier.identifier != null ? 1 : 0) != 0, (Object)"Name must be not null");
            return this.componentIdentifier;
        }
    }
}

