/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.util.Map;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.NamedObject;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OnNoTokenPolicyAware;
import org.mule.security.oauth.callback.HttpCallbackAdapter;

public interface OAuth2Manager<C extends OAuth2Adapter>
extends HttpCallbackAdapter,
ProcessAdapter<OAuth2Adapter>,
OnNoTokenPolicyAware,
NamedObject {
    public C createAdapter(String var1) throws Exception;

    public C acquireAccessToken(String var1) throws Exception;

    public void releaseAccessToken(String var1, C var2) throws Exception;

    public void destroyAccessToken(String var1, C var2) throws Exception;

    public C getDefaultUnauthorizedConnector();

    public KeyedPoolableObjectFactory<String, OAuth2Adapter> getAccessTokenPoolFactory();

    public String buildAuthorizeUrl(Map<String, String> var1, String var2, String var3);

    public void refreshAccessToken(OAuth2Adapter var1, String var2) throws UnableToAcquireAccessTokenException;

    public void fetchAccessToken(OAuth2Adapter var1, String var2) throws UnableToAcquireAccessTokenException;

    public MuleContext getMuleContext();

    public void hasBeenAuthorized(OAuth2Adapter var1) throws NotAuthorizedException;

    public void storeAuthorizationEvent(MuleEvent var1) throws Exception;

    public MuleEvent restoreAuthorizationEvent(String var1) throws ObjectStoreException, ObjectDoesNotExistException;

    @Override
    public <T> ProcessTemplate<T, OAuth2Adapter> getProcessTemplate();

    public String getDefaultAccessTokenId();

    public void postAuth(OAuth2Adapter var1, String var2) throws Exception;
}

