/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.callback;

import java.util.regex.Pattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.HttpCallbackFactory;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.security.oauth.callback.CallbackContinuationMessageProcessor;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.processor.ExtractAuthorizationCodeMessageProcessor;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;

public class DefaultHttpCallbackFactory
implements HttpCallbackFactory {
    private boolean forceOldHttpTransport = false;

    @Override
    public HttpCallback createCallback(HttpCallbackAdapter adapter, String authCodeRegex, FetchAccessTokenMessageProcessor fetchAccessTokenMessageProcessor, MessageProcessor listener, MuleContext muleContext, FlowConstruct flowConstruct) throws MuleException {
        DefaultHttpCallback callback = new DefaultHttpCallback(this.buildCallbackProcessor(authCodeRegex, fetchAccessTokenMessageProcessor, listener), muleContext, adapter.getDomain(), adapter.getLocalPort(), adapter.getRemotePort(), adapter.getPath(), adapter.getAsync(), flowConstruct.getExceptionListener(), adapter.getConnector());
        callback.setForceOldHttpTransport(this.forceOldHttpTransport);
        return callback;
    }

    private MessageProcessor buildCallbackProcessor(String authCodeRegex, FetchAccessTokenMessageProcessor fetchAccessTokenMessageProcessor, MessageProcessor listener) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new ExtractAuthorizationCodeMessageProcessor(Pattern.compile(authCodeRegex)), fetchAccessTokenMessageProcessor, new CallbackContinuationMessageProcessor(listener)}).build();
    }

    @Override
    public void forceOldHttpTransport(boolean forceOld) {
        this.forceOldHttpTransport = forceOld;
    }
}

