/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming.processor;

import java.lang.reflect.Type;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.streaming.Consumer;
import org.mule.streaming.ConsumerIterator;
import org.mule.streaming.ListConsumer;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.PagingDelegateProducer;
import org.mule.streaming.PagingDelegateWrapper;
import org.mule.streaming.Producer;

public abstract class AbstractDevkitBasedPageableMessageProcessor
extends DevkitBasedMessageProcessor {
    private String fetchSize;

    public AbstractDevkitBasedPageableMessageProcessor(String operationName) {
        super(operationName);
    }

    @Override
    protected final MuleEvent doProcess(MuleEvent event) throws Exception {
        PagingDelegateWrapper delegate = this.getPagingDelegate(event, this.makeConfiguration(event));
        if (delegate == null) {
            throw new DefaultMuleException("Obtained paging delegate cannot be null");
        }
        delegate = new PagingDelegateWrapper(delegate);
        PagingDelegateProducer producer = new PagingDelegateProducer((PagingDelegate)delegate);
        ListConsumer consumer = new ListConsumer((Producer)producer);
        event.getMessage().setPayload((Object)new ConsumerIterator((Consumer)consumer));
        return event;
    }

    protected abstract PagingDelegate<?> getPagingDelegate(MuleEvent var1, PagingConfiguration var2) throws Exception;

    private PagingConfiguration makeConfiguration(MuleEvent event) throws MuleException {
        int transformedFetchSize = this.toInt(event, this.fetchSize);
        if (transformedFetchSize <= 0) {
            throw new IllegalArgumentException("Fetch size cannot be lower than zero");
        }
        return new PagingConfiguration(transformedFetchSize);
    }

    private int toInt(MuleEvent event, Object source) throws MuleException {
        try {
            return (Integer)this.evaluateAndTransform(this.muleContext, event, (Type)((Object)Integer.class), null, source);
        }
        catch (Exception e) {
            throw new DefaultMuleException("Error evaluating paging expressions " + source, (Throwable)e);
        }
    }

    public void setFetchSize(String fetchSize) {
        this.fetchSize = fetchSize;
    }
}

