/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.callback;

import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.security.oauth.callback.SaveAccessTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSaveAccessTokenCallback
implements SaveAccessTokenCallback {
    private MessageProcessor messageProcessor;
    private static Logger logger = LoggerFactory.getLogger(DefaultSaveAccessTokenCallback.class);
    private boolean hasBeenStarted = false;
    private boolean hasBeenInitialized = false;

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void setMessageProcessor(MessageProcessor value) {
        this.messageProcessor = value;
    }

    @Override
    public void saveAccessToken(String accessToken, String accessTokenSecret) {
        MuleEvent event = RequestContext.getEvent();
        if (accessToken != null) {
            event.getMessage().setInvocationProperty("OAuthAccessToken", (Object)accessToken);
        }
        if (accessTokenSecret != null) {
            event.getMessage().setInvocationProperty("OAuthAccessTokenSecret", (Object)accessTokenSecret);
        }
        if (this.messageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)this.messageProcessor).setMuleContext(RequestContext.getEventContext().getMuleContext());
        }
        if (this.messageProcessor instanceof FlowConstructAware) {
            ((FlowConstructAware)this.messageProcessor).setFlowConstruct(RequestContext.getEventContext().getFlowConstruct());
        }
        if (!this.hasBeenInitialized) {
            if (this.messageProcessor instanceof Initialisable) {
                try {
                    ((Initialisable)this.messageProcessor).initialise();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.hasBeenInitialized = true;
        }
        if (!this.hasBeenStarted) {
            if (this.messageProcessor instanceof Startable) {
                try {
                    ((Startable)this.messageProcessor).start();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.hasBeenStarted = true;
        }
        try {
            this.messageProcessor.process(event);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

