/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.callback;

import org.apache.log4j.Logger;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.util.NumberUtils;

public class DefaultHttpCallbackAdapter
implements Initialisable,
HttpCallbackAdapter {
    private Integer localPort;
    private Integer remotePort;
    private String domain;
    private String path;
    private Connector connector;
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpCallbackAdapter.class);
    private Boolean async = false;

    @Override
    public Integer getLocalPort() {
        return this.localPort;
    }

    @Override
    public void setLocalPort(Integer value) {
        this.localPort = value;
    }

    @Override
    public Integer getRemotePort() {
        return this.remotePort;
    }

    @Override
    public void setRemotePort(Integer value) {
        this.remotePort = value;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String value) {
        this.domain = value;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String value) {
        this.path = value;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector value) {
        this.connector = value;
    }

    @Override
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public void setAsync(Boolean value) {
        this.async = value;
    }

    public void initialise() throws InitialisationException {
        if (this.localPort == null) {
            String portSystemVar = System.getProperty("http.port");
            if (NumberUtils.isDigits((String)portSystemVar)) {
                this.localPort = Integer.parseInt(portSystemVar);
            } else {
                LOGGER.warn((Object)"Environment variable 'http.port' not found, using default localPort: 8080");
                this.localPort = 8080;
            }
        }
        if (this.remotePort == null) {
            LOGGER.info((Object)"Using default remotePort: 80");
            this.remotePort = 80;
        }
        if (this.domain == null) {
            String domainSystemVar = System.getProperty("fullDomain");
            if (domainSystemVar != null) {
                this.domain = domainSystemVar;
            } else {
                LOGGER.warn((Object)"Environment variable 'fullDomain' not found, using default: localhost");
                this.domain = "localhost";
            }
        }
    }
}

