/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.security.oauth.exception.AuthorizationCodeNotFoundException;

public class ExtractAuthorizationCodeMessageProcessor
implements MessageProcessor {
    private Pattern pattern;

    public ExtractAuthorizationCodeMessageProcessor(Pattern pattern) {
        this.pattern = pattern;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            event.getMessage().setInvocationProperty("_oauthVerifier", (Object)this.extractAuthorizationCode(event.getMessageAsString()));
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Could not extract OAuth verifier"), event, (Throwable)e);
        }
        return event;
    }

    private String extractAuthorizationCode(String response) throws Exception {
        Matcher matcher = this.pattern.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return URLDecoder.decode(matcher.group(1), "UTF-8");
        }
        throw new AuthorizationCodeNotFoundException(this.pattern, response);
    }
}

