/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.util.CharSetUtils;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClobResolvedDataType
extends ResolvedDbType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClobResolvedDataType.class);

    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value != null && !(value instanceof Clob)) {
            try {
                LOGGER.debug("Creating CLOB object");
                Clob clob = statement.getConnection().createClob();
                if (value instanceof String) {
                    clob.setString(1L, (String)value);
                } else if (value instanceof InputStream) {
                    IOUtils.copy((InputStream)((InputStream)value), (Writer)clob.setCharacterStream(1L), (String)CharSetUtils.defaultCharsetName());
                } else {
                    throw new IllegalArgumentException(ClobResolvedDataType.createUnsupportedTypeErrorMessage(value));
                }
                super.setParameterValue(statement, index, clob);
            }
            catch (IOException | SQLException e) {
                LOGGER.debug("Error creating CLOB object. Using alternative way to set CLOB object", (Throwable)e);
                String valueString = value instanceof String ? (String)value : IOUtils.toString((InputStream)((InputStream)value));
                statement.setCharacterStream(index, (Reader)new StringReader(valueString), valueString.length());
            }
        } else {
            super.setParameterValue(statement, index, value);
        }
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a Clob from a value of type '%s'", value.getClass());
    }
}

