/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.executor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.AbstractSingleQueryExecutor;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.statement.StatementFactory;
import org.mule.module.db.internal.result.resultset.ListResultSetHandler;
import org.mule.module.db.internal.result.row.InsensitiveMapRowHandler;

public class UpdateExecutor
extends AbstractSingleQueryExecutor {
    public UpdateExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    protected Object doExecuteQuery(DbConnection connection, Statement statement, Query query) throws SQLException {
        return this.doExecuteQuery(connection, statement, query, new NoAutoGeneratedKeyStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecuteQuery(DbConnection dbConnection, Statement statement, Query query, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        try {
            int updateCount = autoGeneratedKeyStrategy.executeUpdate(statement, query.getQueryTemplate());
            if (autoGeneratedKeyStrategy.returnsAutoGeneratedKeys()) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                ListResultSetHandler listResultSetHandler = new ListResultSetHandler(new InsensitiveMapRowHandler());
                Object object = listResultSetHandler.processResultSet(dbConnection, generatedKeys);
                return object;
            }
            Integer n = updateCount;
            return n;
        }
        finally {
            statement.close();
        }
    }
}

