/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import org.mule.module.db.internal.domain.connection.DefaultDbConnection;
import org.mule.module.db.internal.domain.connection.DefaultDbConnectionReleaser;
import org.mule.module.db.internal.domain.connection.oracle.OracleConnectionUtils;
import org.mule.module.db.internal.domain.connection.type.resolver.CollectionTypeResolver;
import org.mule.module.db.internal.domain.connection.type.resolver.TypeResolver;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.resolver.param.ParamTypeResolverFactory;

public class OracleDbConnection
extends DefaultDbConnection {
    public static final String ATTR_TYPE_NAME_PARAM = "ATTR_TYPE_NAME";
    public static final String ATTR_NO_PARAM = "ATTR_NO";
    public static final String QUERY_TYPE_ATTRS = "SELECT ATTR_NO, ATTR_TYPE_NAME FROM ALL_TYPE_ATTRS WHERE TYPE_NAME = ? AND ATTR_TYPE_NAME IN ('CLOB', 'BLOB')";
    public static final String QUERY_OWNER_CONDITION = " AND OWNER = ?";
    private Method createArrayMethod;
    private boolean initialized;
    private Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache;

    public OracleDbConnection(Connection delegate, TransactionalAction transactionalAction, DefaultDbConnectionReleaser connectionReleaseListener, ParamTypeResolverFactory paramTypeResolverFactory, Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache) {
        super(delegate, transactionalAction, connectionReleaseListener, paramTypeResolverFactory);
        this.resolvedDbTypesCache = resolvedDbTypesCache;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.getCreateArrayOfMethod(this.delegate) == null) {
            return super.createArrayOf(typeName, elements);
        }
        try {
            this.resolveLobs(typeName, elements, new CollectionTypeResolver(this));
            return (Array)this.getCreateArrayOfMethod(this.delegate).invoke((Object)this.delegate, typeName, elements);
        }
        catch (Exception e) {
            throw new SQLException("Error creating ARRAY", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCreateArrayOfMethod(Connection delegate) {
        if (this.createArrayMethod == null && !this.initialized) {
            OracleDbConnection oracleDbConnection = this;
            synchronized (oracleDbConnection) {
                if (this.createArrayMethod == null && !this.initialized) {
                    try {
                        this.createArrayMethod = delegate.getClass().getMethod("createARRAY", String.class, Object.class);
                        this.createArrayMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    this.initialized = true;
                }
            }
        }
        return this.createArrayMethod;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return super.createStruct(typeName, attributes);
    }

    @Override
    protected void resolveLobs(String typeName, Object[] attributes, TypeResolver typeResolver) throws SQLException {
        Map<Integer, ResolvedDbType> dataTypes = this.getLobFieldsDataTypeInfo(typeResolver.resolveType(typeName));
        if (dataTypes.keySet().isEmpty()) {
            this.logger.warn("No catalog information was found for the typename {}. No lob resolution will be performed", (Object)typeName);
        }
        for (Map.Entry<Integer, ResolvedDbType> entry : dataTypes.entrySet()) {
            Integer index = entry.getKey();
            ResolvedDbType dataType = entry.getValue();
            typeResolver.resolveLobs(attributes, index - 1, dataType.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<Integer, ResolvedDbType> getLobFieldsDataTypeInfo(String typeName) throws SQLException {
        if (this.resolvedDbTypesCache.containsKey(typeName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Returning chached LobFieldsDataTypeInfo");
            }
            return this.resolvedDbTypesCache.get(typeName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Obtaining LobFieldsDataTypeInfo");
        }
        Map<String, Map<Integer, ResolvedDbType>> map = this.resolvedDbTypesCache;
        synchronized (map) {
            if (this.resolvedDbTypesCache.containsKey(typeName)) {
                return this.resolvedDbTypesCache.get(typeName);
            }
            HashMap<Integer, ResolvedDbType> dataTypes = new HashMap<Integer, ResolvedDbType>();
            String owner = OracleConnectionUtils.getOwnerFrom(typeName);
            String type = OracleConnectionUtils.getTypeSimpleName(typeName);
            String query = QUERY_TYPE_ATTRS + (owner != null ? QUERY_OWNER_CONDITION : "");
            try (PreparedStatement ps = this.prepareStatement(query);){
                ps.setString(1, type);
                if (owner != null) {
                    ps.setString(2, owner);
                }
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        ResolvedDbType resolvedDbType = new ResolvedDbType(-1, resultSet.getString(ATTR_TYPE_NAME_PARAM));
                        dataTypes.put(resultSet.getInt(ATTR_NO_PARAM), resolvedDbType);
                    }
                }
                this.resolvedDbTypesCache.put(typeName, dataTypes);
                HashMap<Integer, ResolvedDbType> hashMap = dataTypes;
                return hashMap;
            }
        }
    }
}

