/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.resulthandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.Closeable;
import org.mule.api.MuleException;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.resulthandler.RecordHandler;
import org.mule.module.db.sqlexecutor.resulthandler.StreamingResultSetCloser;

public class ResultSetIterator
implements Iterator<Map<String, Object>>,
Closeable {
    protected static Log logger = LogFactory.getLog(ResultSetIterator.class);
    private final ResultSet resultSet;
    private final RecordHandler recordHandler;
    private final StreamingResultSetCloser streamingResultSetCloser;
    private DbConnection connection;
    private Boolean cachedNext = null;

    public ResultSetIterator(DbConnection connection, ResultSet resultSet, RecordHandler recordHandler, StreamingResultSetCloser streamingResultSetCloser) {
        if (connection == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.recordHandler = recordHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
        this.connection = connection;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.cachedNext == null) {
            try {
                this.cachedNext = this.resultSet.next();
                result = this.cachedNext;
            }
            catch (SQLException e) {
                logger.warn((Object)"Unable to determine if there are more records", (Throwable)e);
            }
        } else {
            result = this.cachedNext;
        }
        if (!result) {
            try {
                this.close();
            }
            catch (MuleException muleException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> next() {
        try {
            if (this.cachedNext == null) {
                this.resultSet.next();
            } else {
                this.cachedNext = null;
            }
            return (Map)this.recordHandler.processRecord(this.resultSet);
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to obtain next record", (Throwable)e);
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws MuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Closing resultSet");
        }
        this.streamingResultSetCloser.close(this.connection, this.resultSet);
    }
}

