/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.parser;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.param.DefaultInputSqlParam;
import org.mule.module.db.sqlexecutor.param.SqlParam;
import org.mule.module.db.sqlexecutor.parser.SqlCommandParser;
import org.mule.module.db.sqlexecutor.parser.SqlParserException;
import org.mule.module.db.sqlexecutor.type.UnknownDbType;
import org.mule.util.StringUtils;

public class SimpleSqlCommandParser
implements SqlCommandParser {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] BEGIN_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] END_SKIP = new String[]{"'", "\"", "\n", "*/"};
    private static final Log logger = LogFactory.getLog(SimpleSqlCommandParser.class);

    @Override
    public SqlCommandDefinition parse(String sql) {
        SqlCommandType sqlCommandType = this.isSelect(sql = sql.trim()) ? SqlCommandType.QUERY : (this.isInsert(sql) ? SqlCommandType.INSERT : (this.isDelete(sql) ? SqlCommandType.DELETE : (this.isUpdate(sql) ? SqlCommandType.UPDATE : (this.isStoredProcedureCall(sql) ? SqlCommandType.STORE_PROCEDURE_CALL : SqlCommandType.DDL))));
        return this.doParse(sql, sqlCommandType);
    }

    @Override
    public SqlCommandDefinition parse(SqlCommandType sqlCommandType, String sql) {
        return this.doParse(sql.trim(), sqlCommandType);
    }

    private SqlCommandDefinition doParse(String sqlText, SqlCommandType sqlCommandType) {
        if (StringUtils.isEmpty((String)sqlText)) {
            throw new SqlParserException("SQL text cannot be empty");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Parsing SQL: " + sqlText));
        }
        String sqlToUse = "";
        ArrayList<SqlParam> parameterList = new ArrayList<SqlParam>();
        char[] sqlTextChars = sqlText.toCharArray();
        int tokenStart = 0;
        int paramIndex = 1;
        while (tokenStart < sqlTextChars.length) {
            int skipToPosition;
            while (tokenStart < sqlTextChars.length && tokenStart != (skipToPosition = SimpleSqlCommandParser.skipCommentsAndQuotes(sqlTextChars, tokenStart))) {
                sqlToUse = sqlToUse + sqlText.substring(tokenStart, skipToPosition);
                tokenStart = skipToPosition;
            }
            if (tokenStart >= sqlTextChars.length) break;
            char currentChar = sqlTextChars[tokenStart];
            int tokenEnd = tokenStart + 1;
            if (tokenEnd < sqlTextChars.length && currentChar == '#' && sqlTextChars[tokenEnd] == '[') {
                int openBrackets = 0;
                while (tokenEnd < sqlTextChars.length) {
                    if (sqlTextChars[tokenEnd] == ']') {
                        --openBrackets;
                    } else if (sqlTextChars[tokenEnd] == '[') {
                        ++openBrackets;
                    }
                    if (openBrackets == 0) break;
                    ++tokenEnd;
                }
                if (tokenEnd == sqlTextChars.length) {
                    throw new SqlParserException("Invalid Mule expression: " + sqlText.substring(tokenStart));
                }
                String value = sqlText.substring(tokenStart, ++tokenEnd);
                DefaultInputSqlParam inputParam = new DefaultInputSqlParam(paramIndex++, UnknownDbType.getInstance(), (Object)value);
                parameterList.add(inputParam);
                sqlToUse = sqlToUse + "?";
                tokenStart = tokenEnd;
                continue;
            }
            if (currentChar == ':') {
                while (tokenEnd < sqlTextChars.length && !SimpleSqlCommandParser.isParameterSeparator(sqlTextChars[tokenEnd])) {
                    ++tokenEnd;
                }
                if (tokenEnd - tokenStart > 1) {
                    sqlToUse = sqlToUse + "?";
                    String parameter = sqlText.substring(tokenStart + 1, tokenEnd);
                    DefaultInputSqlParam inputParam = new DefaultInputSqlParam(paramIndex++, UnknownDbType.getInstance(), null, parameter);
                    parameterList.add(inputParam);
                }
                tokenStart = tokenEnd;
                continue;
            }
            if (this.isParamChar(currentChar)) {
                DefaultInputSqlParam inputParam = new DefaultInputSqlParam(paramIndex++, UnknownDbType.getInstance(), (Object)null);
                parameterList.add(inputParam);
                ++tokenStart;
                sqlToUse = sqlToUse + currentChar;
                continue;
            }
            sqlToUse = sqlToUse + currentChar;
            ++tokenStart;
        }
        return new SqlCommandDefinition(sqlToUse, sqlCommandType, parameterList);
    }

    private boolean isParamChar(char c) {
        return c == '?';
    }

    private boolean isStoredProcedureCall(String sqlText) {
        return (sqlText = sqlText.toUpperCase()).startsWith("CALL") || sqlText.startsWith("{ CALL");
    }

    private boolean isUpdate(String sqlText) {
        sqlText = sqlText.toUpperCase();
        return sqlText.startsWith("UPDATE");
    }

    private boolean isInsert(String sqlText) {
        sqlText = sqlText.toUpperCase();
        return sqlText.startsWith("INSERT");
    }

    private boolean isDelete(String sqlText) {
        sqlText = sqlText.toUpperCase();
        return sqlText.startsWith("DELETE");
    }

    private boolean isSelect(String sqlText) {
        return sqlText.toUpperCase().startsWith("SELECT");
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < BEGIN_SKIP.length; ++i) {
            if (statement[position] != BEGIN_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < BEGIN_SKIP[i].length(); ++j) {
                if (statement[position + j] == BEGIN_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = BEGIN_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != END_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < END_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != END_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }
}

