/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.executor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AbstractExecutor;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnIndexAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnNameAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.DefaultAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.NoAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.resulthandler.ListResultSetHandler;
import org.mule.module.db.sqlexecutor.resulthandler.MapRecordHandler;
import org.mule.module.db.sqlexecutor.statement.SqlStatementFactory;

public class UpdateExecutor
extends AbstractExecutor {
    public UpdateExecutor(SqlStatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand) throws SQLException {
        return this.executeSqlCommand(null, statement, sqlCommand, new NoAutoGeneratedKey());
    }

    @Override
    protected Object executeSqlCommand(DbConnection dbConnection, Statement statement, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        if (autoGeneratedKey.retrieveAutoGeneratedKeys()) {
            return this.processWithMultipleAutoGeneratedKeys(dbConnection, statement, sqlCommand, autoGeneratedKey);
        }
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, sqlCommand.getSqlCommandDefinition().getParams(), sqlCommand.getParamValues());
            return ((PreparedStatement)statement).executeUpdate();
        }
        return statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), 2);
    }

    private Object processWithMultipleAutoGeneratedKeys(DbConnection connection, Statement statement, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, sqlCommand.getSqlCommandDefinition().getParams(), sqlCommand.getParamValues());
            ((PreparedStatement)statement).executeUpdate();
        } else if (autoGeneratedKey instanceof ColumnIndexAutoGeneratedKey) {
            statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), ((ColumnIndexAutoGeneratedKey)autoGeneratedKey).getColumnIndexes());
        } else if (autoGeneratedKey instanceof DefaultAutoGeneratedKey) {
            statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), 1);
        } else if (autoGeneratedKey instanceof ColumnNameAutoGeneratedKey) {
            statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), ((ColumnNameAutoGeneratedKey)autoGeneratedKey).getColumnNames());
        } else {
            throw new IllegalArgumentException("Not supported auto generated key: " + autoGeneratedKey.getClass().getName());
        }
        ResultSet generatedKeys = statement.getGeneratedKeys();
        ListResultSetHandler listResultSetHandler = new ListResultSetHandler(new MapRecordHandler());
        return listResultSetHandler.processResultSet(connection, generatedKeys);
    }
}

