/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.connection;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.module.db.connection.DbConnectionFactory;
import org.mule.module.db.sqlexecutor.connection.ConnectionBindingException;
import org.mule.module.db.sqlexecutor.connection.ConnectionClosingException;
import org.mule.module.db.sqlexecutor.connection.ConnectionCommitException;
import org.mule.module.db.sqlexecutor.connection.ConnectionCreationException;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.connection.DefaultDbConnection;
import org.mule.module.db.sqlexecutor.connection.DefaultDbConnectionReleaseListener;
import org.mule.module.db.sqlexecutor.transaction.TransactionManager;
import org.mule.module.db.transaction.TransactionalAction;

public class DefaultDbConnectionFactory
implements DbConnectionFactory {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected final DbConfig dbConfig;
    protected final TransactionManager transactionManager;

    public DefaultDbConnectionFactory(DbConfig dbConfig, TransactionManager transactionManager) {
        this.dbConfig = dbConfig;
        this.transactionManager = transactionManager;
    }

    @Override
    public DbConnection createConnection(TransactionalAction transactionalAction) throws SQLException {
        Connection connection;
        Transaction tx = this.transactionManager.getTransaction();
        if (transactionalAction == TransactionalAction.ALWAYS_JOIN) {
            if (tx == null) {
                throw new IllegalStateException("Transactional action is " + (Object)((Object)transactionalAction) + " but there is no active transaction");
            }
            connection = this.getConnectionFromTransaction(this.dbConfig, tx);
        } else if (transactionalAction == TransactionalAction.JOIN_IF_POSSIBLE) {
            connection = tx == null ? this.getConnectionFromDataSource(this.dbConfig) : this.getConnectionFromTransaction(this.dbConfig, tx);
        } else if (transactionalAction == TransactionalAction.NOT_SUPPORTED) {
            connection = this.getConnectionFromDataSource(this.dbConfig);
        } else {
            throw new IllegalArgumentException("There is no defined way to manage transactional action " + (Object)((Object)transactionalAction));
        }
        return this.doCreatetJdbcConnection(connection, transactionalAction);
    }

    protected DbConnection doCreatetJdbcConnection(Connection connection, TransactionalAction transactionalAction) {
        return new DefaultDbConnection(connection, transactionalAction, new DefaultDbConnectionReleaseListener(this));
    }

    private Connection getConnectionFromDataSource(DbConfig config) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Retrieving new connection from data source");
        }
        try {
            return config.getDataSource().getConnection();
        }
        catch (Exception e) {
            throw new ConnectionCreationException(e);
        }
    }

    private Connection getConnectionFromTransaction(DbConfig config, Transaction tx) throws SQLException {
        Connection con;
        if (tx.hasResource((Object)config.getDataSource())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving connection from current transaction: " + tx));
            }
            con = (Connection)tx.getResource((Object)config.getDataSource());
        } else {
            con = this.getConnectionFromDataSource(config);
            try {
                tx.bindResource((Object)config.getDataSource(), (Object)con);
            }
            catch (TransactionException e) {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
                throw new ConnectionBindingException("Could not bind connection to current transaction: " + tx, e);
            }
        }
        return con;
    }

    @Override
    public void releaseConnection(DbConnection connection) {
        try {
            if (connection.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            return;
        }
        Transaction transaction = this.transactionManager.getTransaction();
        boolean closeConnection = false;
        if (connection.getTransactionalAction() == TransactionalAction.NOT_SUPPORTED) {
            closeConnection = true;
        } else if (connection.getTransactionalAction() == TransactionalAction.JOIN_IF_POSSIBLE && transaction == null) {
            closeConnection = true;
        }
        if (closeConnection) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                throw new ConnectionCommitException(e);
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new ConnectionClosingException(e);
            }
        }
    }
}

