/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.connection;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbPoolingProfile;
import org.mule.module.db.sqlexecutor.connection.DbTypeResolver;
import org.mule.module.db.sqlexecutor.connection.DefaultDbConnectionFactory;
import org.mule.module.db.sqlexecutor.connection.MetadataTypeResolver;
import org.mule.module.db.sqlexecutor.type.DbTypeManager;
import org.mule.module.db.sqlexecutor.type.MetadataDbTypeManager;
import org.mule.module.db.transaction.DefaultTransactionManager;
import org.mule.module.db.xa.CompositeDataSourceDecorator;

public class DefaultDbConfig
implements DbConfig,
Initialisable {
    private DataSource dataSource;
    private final String name;
    private final DefaultDbConnectionFactory jdbcConfigConnectionFactory;
    private final DbTypeResolver dbTypeResolver;
    private final DbTypeManager metadataDbTypeManager;
    private final CompositeDataSourceDecorator databaseDecorator = new CompositeDataSourceDecorator();
    private DbPoolingProfile poolingProfile;
    private boolean useXaTransactions;
    private String username;
    private String password;
    private int connectionTimeout;
    private int transactionIsolation;
    private String driverClassName;
    private MuleContext muleContext;
    private String url;

    public DefaultDbConfig(DataSource dataSource, String name) {
        this.dataSource = dataSource;
        this.name = name;
        this.jdbcConfigConnectionFactory = this.doCreatetConnectionFactory();
        this.metadataDbTypeManager = this.doCreateTypeManager();
        this.dbTypeResolver = this.doCreateTypeResolver();
    }

    private MetadataDbTypeManager doCreateTypeManager() {
        return new MetadataDbTypeManager(this.jdbcConfigConnectionFactory);
    }

    private DbTypeResolver doCreateTypeResolver() {
        return new MetadataTypeResolver(this.metadataDbTypeManager);
    }

    protected DefaultDbConnectionFactory doCreatetConnectionFactory() {
        return new DefaultDbConnectionFactory(this, new DefaultTransactionManager());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DefaultDbConnectionFactory getConnectionFactory() {
        return this.jdbcConfigConnectionFactory;
    }

    @Override
    public DbTypeManager getJdbcTypeManager() {
        return this.metadataDbTypeManager;
    }

    @Override
    public DbTypeResolver getDbTypeResolver() {
        return this.dbTypeResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.SUCCESS);
            return defaultTestResult;
        }
        catch (SQLException e) {
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.FAILURE, e.getMessage());
            return defaultTestResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        ArrayList keys = new ArrayList();
        return new DefaultResult(keys, Result.Status.SUCCESS, "This is a success message");
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        return new DefaultResult(null, Result.Status.SUCCESS, "This is a success message");
    }

    public void initialise() throws InitialisationException {
        this.databaseDecorator.init(this.muleContext);
        DataSource instanceDatasource = this.dataSource;
        if (instanceDatasource == null) {
            try {
                this.dataSource = this.createDataSource();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected DataSource createDataSource() throws Exception {
        if (this.poolingProfile == null) {
            DataSource singleDataSource = this.createSingleDataSource();
            if (this.useXaTransactions) {
                singleDataSource = this.decorateDataSourceIfRequired(singleDataSource);
            }
            return singleDataSource;
        }
        return this.createPooledDataSource();
    }

    private DataSource createSingleDataSource() throws SQLException {
        StandardXADataSource dataSource = this.useXaTransactions ? new StandardXADataSource() : new StandardDataSource();
        dataSource.setDriverName(this.driverClassName);
        if (this.connectionTimeout >= 0) {
            dataSource.setLoginTimeout(this.connectionTimeout);
        }
        dataSource.setPassword(this.password);
        dataSource.setTransactionIsolation(this.transactionIsolation);
        dataSource.setUrl(this.url);
        dataSource.setUser(this.username);
        return dataSource;
    }

    private DataSource createPooledDataSource() throws PropertyVetoException, SQLException {
        if (this.useXaTransactions) {
            return this.createPooledXaDataSource();
        }
        return this.createPooledStandardDatasource();
    }

    private DataSource createPooledStandardDatasource() throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(this.driverClassName);
        dataSource.setJdbcUrl(this.url);
        dataSource.setUser(this.username);
        dataSource.setPassword(this.password);
        dataSource.setInitialPoolSize(this.poolingProfile.getMinPoolSize());
        dataSource.setMinPoolSize(this.poolingProfile.getMinPoolSize());
        dataSource.setMaxPoolSize(this.poolingProfile.getMaxPoolSize());
        dataSource.setAcquireIncrement(this.poolingProfile.getAcquireIncrement());
        dataSource.setMaxStatements(0);
        dataSource.setMaxStatementsPerConnection(this.poolingProfile.getPreparedStatementCacheSize());
        dataSource.setCheckoutTimeout(this.poolingProfile.getMaxWaitMillis());
        return dataSource;
    }

    private DataSource createPooledXaDataSource() throws SQLException {
        DataSource dataSource = this.createSingleDataSource();
        return this.decorateDataSourceIfRequired(dataSource);
    }

    private DataSource decorateDataSourceIfRequired(DataSource dataSource) {
        return this.databaseDecorator.decorate(dataSource, this.getName(), this.poolingProfile, this.muleContext);
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.useXaTransactions = useXaTransactions;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

