/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.resolver;

import org.mule.api.MuleEvent;
import org.mule.module.db.resolver.BatchSqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.BulkSqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.parser.SimpleSqlCommandParser;

public abstract class AbstractBulkSqlCommandResolver
implements BatchSqlCommandResolver {
    private final String bulkQuery;

    public AbstractBulkSqlCommandResolver(String bulkQuery) {
        this.bulkQuery = bulkQuery;
    }

    @Override
    public BulkSqlCommand resolve(MuleEvent muleEvent) {
        if (muleEvent == null) {
            return null;
        }
        BulkSqlCommand bulkSqlCommand = this.createBulkSqlCommand(this.resolveBulkQueries(muleEvent, this.bulkQuery));
        if (bulkSqlCommand.getCommands().size() == 0) {
            throw new IllegalStateException("There are no queries on the resolved dynamic bulk query: " + this.bulkQuery);
        }
        return bulkSqlCommand;
    }

    protected String resolveBulkQueries(MuleEvent muleEvent, String bulkQuery) {
        return bulkQuery.trim();
    }

    protected BulkSqlCommand createBulkSqlCommand(String queries) {
        String[] splitQueries;
        BulkSqlCommand bulkSqlCommand = new BulkSqlCommand();
        SimpleSqlCommandParser parser = new SimpleSqlCommandParser();
        for (String query : splitQueries = queries.split(";\n")) {
            if ("".equals(query.trim())) continue;
            SqlCommandDefinition sqlCommandDefinition = parser.parse(query);
            SqlCommand sqlCommand = new SqlCommand(sqlCommandDefinition);
            bulkSqlCommand.add(sqlCommand);
        }
        return bulkSqlCommand;
    }
}

