/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.metadata;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.module.db.metadata.DbMetadataFactory;
import org.mule.module.db.metadata.MetadataProvider;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.transaction.TransactionalAction;

public class DefaultMetadataProvider
implements MetadataProvider {
    protected final DbMetadataFactory metadataFactory;
    private final SqlCommandResolver sqlCommandResolver;
    private final DbConfigResolver dbConfigResolver;

    public DefaultMetadataProvider(DbConfigResolver dbConfigResolver, DbMetadataFactory metadataFactory, SqlCommandResolver sqlCommandResolver) {
        this.metadataFactory = metadataFactory;
        this.sqlCommandResolver = sqlCommandResolver;
        this.dbConfigResolver = dbConfigResolver;
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        SqlCommand sqlCommand = this.sqlCommandResolver.resolve(null);
        if (sqlCommand.isDynamic()) {
            return new DefaultResult(null, Result.Status.FAILURE, "Cannot obtain metadata from a dynamic SQL");
        }
        return this.getMetaDataResult(sqlCommand, new InputMetadataResolver());
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData metaData) {
        SqlCommand sqlCommand = this.sqlCommandResolver.resolve(null);
        if (sqlCommand.isDynamic()) {
            Result<MetaData> staticMetadata = this.metadataFactory.getStaticOutputMetadata();
            if (staticMetadata != null) {
                return staticMetadata;
            }
            return new DefaultResult(null, Result.Status.FAILURE, "Cannot obtain metadata from a dynamic SQL");
        }
        return this.getMetaDataResult(sqlCommand, new OutputMetadataResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<MetaData> getMetaDataResult(SqlCommand sqlCommand, MetadataResolver metadataResolver) {
        DbConnection connection = null;
        DbConfig dbConfig = this.dbConfigResolver.resolve(null);
        try {
            PreparedStatement preparedStatement;
            try {
                connection = dbConfig.getConnectionFactory().createConnection(TransactionalAction.NOT_SUPPORTED);
            }
            catch (SQLException e) {
                DefaultResult defaultResult = new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.CONNECTION_FAILURE, (Throwable)e);
                if (connection != null) {
                    dbConfig.getConnectionFactory().releaseConnection(connection);
                }
                return defaultResult;
            }
            try {
                preparedStatement = connection.prepareStatement(sqlCommand.getSqlCommandDefinition().getSqlText());
            }
            catch (SQLException e) {
                DefaultResult defaultResult = new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.INVALID_CONFIGURATION, (Throwable)e);
                if (connection != null) {
                    dbConfig.getConnectionFactory().releaseConnection(connection);
                }
                return defaultResult;
            }
            Result<MetaData> result = metadataResolver.resolveMedata(preparedStatement, sqlCommand);
            return result;
        }
        finally {
            if (connection != null) {
                dbConfig.getConnectionFactory().releaseConnection(connection);
            }
        }
    }

    private class InputMetadataResolver
    implements MetadataResolver {
        private InputMetadataResolver() {
        }

        @Override
        public Result<MetaData> resolveMedata(PreparedStatement statement, SqlCommand sqlCommand) {
            return DefaultMetadataProvider.this.metadataFactory.getDynamicInputMetadata(statement, sqlCommand);
        }
    }

    private class OutputMetadataResolver
    implements MetadataResolver {
        private OutputMetadataResolver() {
        }

        @Override
        public Result<MetaData> resolveMedata(PreparedStatement statement, SqlCommand sqlCommand) {
            return DefaultMetadataProvider.this.metadataFactory.getDynamicOutputMetadata(statement);
        }
    }

    private static interface MetadataResolver {
        public Result<MetaData> resolveMedata(PreparedStatement var1, SqlCommand var2);
    }
}

