/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import org.mule.module.db.config.AbstractBatchUpdateProcessorBeanDefinitionParser;
import org.mule.module.db.config.BulkSqlCommandResolverFactoryBean;
import org.mule.module.db.metadata.BulkUpdateMetadataFactory;
import org.mule.module.db.metadata.BulkUpdateMetadataProvider;
import org.mule.module.db.processor.BulkUpdateMessageProcessor;
import org.mule.module.db.resolver.FileBulkSqlCommandResolver;
import org.mule.module.db.sqlexecutor.executor.NoAutoGeneratedKey;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class BulkUpdateProcessorBeanDefinitionParser
extends AbstractBatchUpdateProcessorBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return BulkUpdateMessageProcessor.class;
    }

    @Override
    protected Object getMetadataProvider() {
        BeanDefinitionBuilder metadataProviderBuilder = BeanDefinitionBuilder.genericBeanDefinition(BulkUpdateMetadataProvider.class);
        metadataProviderBuilder.addConstructorArgValue((Object)new BulkUpdateMetadataFactory(new NoAutoGeneratedKey()));
        return metadataProviderBuilder.getBeanDefinition();
    }

    @Override
    protected void doParseElement(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseConfig(element, builder);
        this.parseBulkSqlCommand(element, builder);
        this.parseSourceExpression(element, builder);
        this.parseTargetExpression(element, builder);
        this.parseExecutorFactory(element, builder);
        this.parseTransactionalAction(element, builder);
        this.parseMetadataProvider(element, builder);
    }

    private void parseBulkSqlCommand(Element element, BeanDefinitionBuilder builder) {
        String file = element.getAttribute("file");
        String queryText = element.getTextContent();
        if (StringUtils.isEmpty((String)file)) {
            BeanDefinitionBuilder sqlParamResolverFactory = BeanDefinitionBuilder.genericBeanDefinition(BulkSqlCommandResolverFactoryBean.class);
            sqlParamResolverFactory.addConstructorArgValue((Object)queryText);
            builder.addConstructorArgValue((Object)sqlParamResolverFactory.getBeanDefinition());
        } else {
            builder.addConstructorArgValue((Object)new FileBulkSqlCommandResolver(file));
        }
    }
}

