/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.support;

import java.util.Arrays;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.mule.extension.http.api.HttpAttributes;
import org.mule.runtime.core.api.message.InternalMessage;

public abstract class AbstractProxyGZIPInterceptor
extends AbstractPhaseInterceptor<Message> {
    public AbstractProxyGZIPInterceptor(String phase) {
        super(phase);
    }

    protected boolean isEncoded(InternalMessage message) {
        boolean isEncoded = false;
        String contentEncoding = (String)((Object)message.getInboundProperty("Content-Encoding"));
        if (contentEncoding == null && message.getAttributes() instanceof HttpAttributes) {
            contentEncoding = ((HttpAttributes)message.getAttributes()).getHeaders().get((Object)"Content-Encoding".toLowerCase());
        }
        if (contentEncoding == null) {
            contentEncoding = (String)((Object)message.getInboundProperty("SOAPJMS_contentEncoding"));
        }
        if (contentEncoding != null) {
            List<String> encodings = Arrays.asList(GZIPOutInterceptor.ENCODINGS.split(contentEncoding.trim()));
            isEncoded = encodings.contains("gzip") || encodings.contains("x-gzip");
        }
        return isEncoded;
    }
}

