/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.mule.compatibility.module.cxf.feature.PrettyLoggingInInterceptor;
import org.mule.compatibility.module.cxf.feature.PrettyLoggingOutInterceptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.xml.transformer.XmlPrettyPrinter;

public class PrettyLoggingFeature
extends LoggingFeature {
    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(new PrettyLoggingInInterceptor(this.getLimit()));
        provider.getOutInterceptors().add(new PrettyLoggingOutInterceptor(this.getLimit()));
    }

    protected static String formatXmlPayload(String originalLogString) {
        Object[] lines = originalLogString.split("\n");
        int payloadLine = -1;
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("Payload: ")) continue;
            payloadLine = i;
            break;
        }
        if (payloadLine == -1) {
            System.err.println("Could not find a line which begins with 'Payload: '");
            return originalLogString;
        }
        String payload = lines[payloadLine];
        String xml = StringUtils.substringAfter((String)payload, (String)"Payload: ");
        XmlPrettyPrinter pp = new XmlPrettyPrinter();
        try {
            xml = (String)pp.transform((Object)xml);
        }
        catch (MuleException e) {
            System.err.println(e.getMessage());
        }
        lines[payloadLine] = "Payload: \n" + xml;
        return StringUtils.join((Object[])lines, (String)"\n");
    }
}

