/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.mule.compatibility.module.cxf.CxfConfiguration;
import org.mule.compatibility.module.cxf.CxfOutboundMessageProcessor;
import org.mule.compatibility.module.cxf.support.DelegatingOutputStream;
import org.mule.compatibility.module.cxf.transport.MuleUniversalTransport;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.message.OutputHandler;

public class MuleUniversalConduit
extends AbstractConduit {
    private static final Logger LOGGER = LogUtils.getL7dLogger(MuleUniversalConduit.class);
    private EndpointInfo endpoint;
    protected CxfConfiguration configuration;
    private MuleUniversalTransport transport;
    private boolean closeInput = true;

    public MuleUniversalConduit(MuleUniversalTransport transport, CxfConfiguration configuration, EndpointInfo ei, EndpointReferenceType t) {
        super(MuleUniversalConduit.getTargetReference(ei, t));
        this.transport = transport;
        this.endpoint = ei;
        this.configuration = configuration;
    }

    public void close(org.apache.cxf.message.Message msg) throws IOException {
        InputStream in;
        OutputStream os = (OutputStream)msg.getContent(OutputStream.class);
        if (os != null) {
            os.close();
        }
        if (this.closeInput && (in = (InputStream)msg.getContent(InputStream.class)) != null) {
            in.close();
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        boolean decoupled;
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        DelegatingOutputStream delegating = new DelegatingOutputStream(cache);
        message.setContent(OutputStream.class, (Object)delegating);
        message.setContent(DelegatingOutputStream.class, (Object)delegating);
        OutputHandler handler = (event, out) -> {
            out.write(cache.toByteArray());
            delegating.setOutputStream(out);
            message.getInterceptorChain().doIntercept(message);
        };
        Event event2 = (Event)message.getExchange().get((Object)"mule.event");
        boolean bl = decoupled = event2 != null && message.getExchange().getInMessage() != null;
        if (event2 == null || decoupled) {
            InternalMessage muleMsg = InternalMessage.builder().payload((Object)handler).build();
            String url = this.setupURL(message);
            try {
                FlowConstruct flowConstruct = new FlowConstruct(){

                    public MuleContext getMuleContext() {
                        return MuleUniversalConduit.this.configuration.getMuleContext();
                    }

                    public String getUniqueIdString() {
                        return MuleUniversalConduit.this.configuration.getMuleContext().getUniqueIdString();
                    }

                    public String getServerId() {
                        return MuleUniversalConduit.this.configuration.getMuleContext().getId();
                    }

                    public String getName() {
                        return "MuleUniversalConduit";
                    }

                    public LifecycleState getLifecycleState() {
                        return null;
                    }

                    public MessagingExceptionHandler getExceptionListener() {
                        return null;
                    }

                    public FlowConstructStatistics getStatistics() {
                        return null;
                    }
                };
                event2 = Event.builder((EventContext)(event2 == null ? DefaultEventContext.create((FlowConstruct)flowConstruct, (String)"MuleUniversalConduit") : event2.getContext())).message((Message)muleMsg).flow(flowConstruct).build();
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        } else {
            event2 = Event.builder((Event)event2).message((Message)InternalMessage.builder((Message)event2.getMessage()).payload((Object)handler).mediaType(MediaType.XML).build()).build();
        }
        if (!decoupled) {
            message.getExchange().put((Object)"mule.event", (Object)event2);
        }
        message.put((Object)"mule.event", (Object)event2);
        AbstractPhaseInterceptor<org.apache.cxf.message.Message> i = new AbstractPhaseInterceptor<org.apache.cxf.message.Message>("pre-stream"){

            public void handleMessage(org.apache.cxf.message.Message m) throws Fault {
                try {
                    MuleUniversalConduit.this.dispatchMuleMessage(m, (Event)m.getExchange().get((Object)"mule.event"));
                }
                catch (MuleException e) {
                    throw new Fault((Throwable)e);
                }
            }
        };
        message.getInterceptorChain().add((Interceptor)i);
    }

    public String setupURL(org.apache.cxf.message.Message message) throws MalformedURLException {
        int slashIdx;
        String result;
        String value = (String)message.get((Object)org.apache.cxf.message.Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)org.apache.cxf.message.Message.PATH_INFO);
        String queryString = (String)message.get((Object)org.apache.cxf.message.Message.QUERY_STRING);
        String username = (String)message.get((Object)"javax.xml.ws.security.auth.username");
        String password = (String)message.get((Object)"javax.xml.ws.security.auth.password");
        String string = result = value != null ? value : this.getTargetOrEndpoint();
        if (username != null && (slashIdx = result.indexOf("//")) != -1) {
            result = result.substring(0, slashIdx + 2) + username + ":" + password + "@" + result.substring(slashIdx + 2);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return result;
    }

    protected void dispatchMuleMessage(org.apache.cxf.message.Message m, Event reqEvent) throws MuleException {
        try {
            Event.setCurrentEvent((Event)reqEvent);
            this.sendResultBackToCxf(m, this.processNext(reqEvent, m.getExchange()));
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Could not send message to Mule."), (Throwable)e);
        }
    }

    protected void sendResultBackToCxf(org.apache.cxf.message.Message m, Event resEvent) throws TransformerException, IOException {
        if (resEvent != null) {
            m.getExchange().put((Object)"mule.event", (Object)resEvent);
            InternalMessage result = resEvent.getMessage();
            InputStream is = this.getResponseBody(m, resEvent);
            if (is != null) {
                DataType dataType = MediaType.ANY.matches(result.getPayload().getDataType().getMediaType()) ? DataType.builder((DataType)result.getPayload().getDataType()).mediaType(MediaType.XML).build() : result.getPayload().getDataType();
                MessageImpl inMessage = new MessageImpl();
                dataType.getMediaType().getCharset().ifPresent(arg_0 -> MuleUniversalConduit.lambda$sendResultBackToCxf$1((org.apache.cxf.message.Message)inMessage, arg_0));
                inMessage.put((Object)"Content-Type", (Object)dataType.toString());
                inMessage.setContent(InputStream.class, (Object)is);
                inMessage.setExchange(m.getExchange());
                this.getMessageObserver().onMessage((org.apache.cxf.message.Message)inMessage);
                return;
            }
        }
        m.getExchange().put((Object)"exchange.finished", (Object)Boolean.TRUE);
    }

    protected InputStream getResponseBody(org.apache.cxf.message.Message m, Event result) throws TransformerException, IOException {
        boolean response;
        boolean bl = response = result != null && result.getMessage().getPayload().getValue() != null && !this.isOneway(m.getExchange());
        if (response) {
            InputStream is = (InputStream)this.configuration.getMuleContext().getTransformationService().transform(result.getMessage(), DataType.INPUT_STREAM).getPayload().getValue();
            PushbackInputStream pb = new PushbackInputStream(is);
            result = Event.builder((Event)result).message((Message)InternalMessage.builder((Message)result.getMessage()).payload((Object)pb).mediaType(MediaType.XML).build()).build();
            int b = pb.read();
            if (b != -1) {
                pb.unread(b);
                return pb;
            }
        }
        m.getExchange().put((Object)"mule.event", (Object)result);
        return null;
    }

    protected boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    protected String getTargetOrEndpoint() {
        if (this.target != null) {
            return this.target.getAddress().getValue();
        }
        return this.endpoint.getAddress();
    }

    public void onClose(org.apache.cxf.message.Message m) throws IOException {
    }

    protected Event processNext(Event event, Exchange exchange) throws MuleException {
        CxfOutboundMessageProcessor processor = (CxfOutboundMessageProcessor)((Object)exchange.get((Object)"cxf_outbound_message_processor"));
        Event response = processor.processNext(event);
        Holder holder = (Holder)exchange.get((Object)"holder");
        holder.value = response;
        return response;
    }

    public void close() {
    }

    protected static EndpointReferenceType getTargetReference(EndpointInfo ei, EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(ei.getAddress());
            ref.setAddress(address);
            if (ei.getService() != null) {
                EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)ei.getService().getName(), (String)ei.getName().getLocalPart());
            }
        } else {
            ref = t;
        }
        return ref;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    protected CxfConfiguration getConnector() {
        return this.configuration;
    }

    protected EndpointInfo getEndpoint() {
        return this.endpoint;
    }

    protected MuleUniversalTransport getTransport() {
        return this.transport;
    }

    private static /* synthetic */ void lambda$sendResultBackToCxf$1(org.apache.cxf.message.Message inMessage, Charset encoding) {
        inMessage.put((Object)org.apache.cxf.message.Message.ENCODING, (Object)encoding.name());
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(org.apache.cxf.message.Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            inMessage.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            MuleUniversalConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

