/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.support;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLQueryHandler
implements StemMatchingQueryHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLQueryHandler.class);
    protected Bus bus;

    public WSDLQueryHandler(Bus b) {
        this.bus = b;
    }

    public String getResponseContentType(String baseUri, String ctx) {
        if (baseUri.toLowerCase().contains("?wsdl") || baseUri.toLowerCase().contains("?xsd=")) {
            return MediaType.XML.toRfcString();
        }
        return null;
    }

    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo, boolean contextMatchExact) {
        int idx;
        Map map;
        if (baseUri != null && baseUri.contains("?") && (baseUri.toLowerCase().contains("wsdl") || baseUri.toLowerCase().contains("xsd=")) && ((map = UrlUtils.parseQueryString((String)baseUri.substring((idx = baseUri.indexOf("?")) + 1))).containsKey("wsdl") || map.containsKey("xsd"))) {
            if (contextMatchExact) {
                return endpointInfo.getAddress().contains(ctx);
            }
            return endpointInfo.getAddress().contains(UrlUtils.getStem((String)baseUri.substring(0, idx)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(String baseUri, String ctxUri, EndpointInfo endpointInfo, OutputStream os) {
        try {
            Document doc;
            String xsd;
            int idx = baseUri.toLowerCase().indexOf("?");
            Map params = UrlUtils.parseQueryString((String)baseUri.substring(idx + 1));
            String base = endpointInfo.getProperty("publishedEndpointUrl") != null ? String.valueOf(endpointInfo.getProperty("publishedEndpointUrl")) : baseUri.substring(0, baseUri.toLowerCase().indexOf("?"));
            String wsdl = (String)params.get("wsdl");
            if (wsdl != null) {
                wsdl = URLDecoder.decode(wsdl, "utf-8");
            }
            if ((xsd = (String)params.get("xsd")) != null) {
                xsd = URLDecoder.decode(xsd, "utf-8");
            }
            Map mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName())));
            Map smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas")));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName(), new ConcurrentHashMap());
                mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName())));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(WSDLQueryHandler.class.getName() + ".Schemas", new ConcurrentHashMap());
                smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLQueryHandler.class.getName() + ".Schemas")));
            }
            if (!mp.containsKey("")) {
                Definition def = this.getDefinition(endpointInfo);
                mp.put("", def);
                this.updateDefinition(def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Object wsdl2;
                Definition def = (Definition)mp.get(wsdl);
                if (def == null && (wsdl2 = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)this.bus), wsdl, base)) != null) {
                    def = (Definition)mp.get(wsdl2);
                }
                if (def == null) {
                    throw new WSDLQueryException(new Message("WSDL_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                }
                wsdl2 = def;
                synchronized (wsdl2) {
                    if (endpointInfo.getProperty("publishedEndpointUrl") != null) {
                        String publishingUrl = String.valueOf(endpointInfo.getProperty("publishedEndpointUrl"));
                        this.updatePublishedEndpointUrl(publishingUrl, def, endpointInfo.getName());
                    }
                    WSDLWriter wsdlWriter = ((WSDLManager)this.bus.getExtension(WSDLManager.class)).getWSDLFactory().newWSDLWriter();
                    def.setExtensionRegistry(((WSDLManager)this.bus.getExtension(WSDLManager.class)).getExtensionRegistry());
                    doc = wsdlWriter.getDocument(def);
                }
            } else {
                String xsd2;
                SchemaReference si = (SchemaReference)smp.get(xsd);
                if (si == null && (xsd2 = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)this.bus), xsd, base)) != null) {
                    si = (SchemaReference)smp.get(xsd2);
                }
                if (si == null) {
                    throw new WSDLQueryException(new Message("SCHEMA_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                }
                String uri = si.getReferencedSchema().getDocumentBaseURI();
                uri = WSDLQueryHandler.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)this.bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                if (uri == null) {
                    uri = si.getReferencedSchema().getDocumentBaseURI();
                }
                ResourceManagerWSDLLocator rml = new ResourceManagerWSDLLocator(uri, this.bus);
                InputSource src = rml.getBaseInputSource();
                doc = XMLUtils.getParser().parse(src);
            }
            this.updateDoc(doc, base, mp, smp, endpointInfo);
            String enc = null;
            try {
                enc = doc.getXmlEncoding();
            }
            catch (Exception uri) {
                // empty catch block
            }
            if (enc == null) {
                enc = "utf-8";
            }
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)enc);
            StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
            writer.flush();
        }
        catch (WSDLQueryException wex) {
            throw wex;
        }
        catch (Exception wex) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{baseUri}), (Throwable)wex);
        }
    }

    protected Definition getDefinition(EndpointInfo endpointInfo) throws WSDLException {
        return new ServiceWSDLBuilder(this.bus, new ServiceInfo[]{endpointInfo.getService()}).build();
    }

    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, EndpointInfo ei) {
        List elementList = null;
        try {
            String sl;
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", this.rewriteSchemaLocation(base, sl));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"include");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", this.rewriteSchemaLocation(base, sl));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"redefine");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", this.rewriteSchemaLocation(base, sl));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("location");
                if (!mp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("location", base + "?wsdl=" + sl.replace(" ", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), (Throwable)e);
        }
        this.rewriteOperationAddress(ei, doc, base);
        try {
            doc.setXmlStandalone(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String rewriteSchemaLocation(String base, String schemaLocation) {
        return base + "?xsd=" + schemaLocation.replace(" ", "%20");
    }

    protected void rewriteOperationAddress(EndpointInfo ei, Document doc, String base) {
        Boolean rewriteSoapAddress = (Boolean)ei.getProperty("autoRewriteSoapAddress", Boolean.class);
        List elementList = null;
        if (rewriteSoapAddress != null && rewriteSoapAddress.booleanValue()) {
            List serviceList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service");
            for (Element serviceEl : serviceList) {
                String serviceName = serviceEl.getAttribute("name");
                if (!serviceName.equals(ei.getService().getName().getLocalPart())) continue;
                elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
                for (Element el : elementList) {
                    String name = el.getAttribute("name");
                    if (!name.equals(ei.getName().getLocalPart())) continue;
                    Element soapAddress = (Element)DOMUtils.findAllElementsByTagNameNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"address").iterator().next();
                    soapAddress.setAttribute("location", base);
                }
            }
        }
    }

    static String resolveWithCatalogs(OASISCatalogManager catalogs, String start, String base) {
        if (catalogs == null) {
            return null;
        }
        String resolvedSchemaLocation = null;
        try {
            resolvedSchemaLocation = catalogs.resolveSystem(start);
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.resolveURI(start);
            }
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.resolvePublic(start, base);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resolvedSchemaLocation;
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)this.bus);
        Collection imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), (Throwable)e);
                }
                String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                        this.updateDefinition(imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast((List)types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(see, doneSchemas, base);
            }
        }
    }

    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        Collection services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn((Port)ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
    }

    private void setSoapAddressLocationOn(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }

    protected void updateSchemaImports(Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)this.bus);
        Collection imports = CastUtils.cast(schema.getImports().values());
        for (Object lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (SchemaImport imp : impLst) {
                String start2 = imp.getSchemaLocationURI();
                if (start2 == null) continue;
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start2, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start2}), (Throwable)e);
                }
                if (doneSchemas.containsKey(decodedStart)) continue;
                String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start2, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        this.checkSchemaUrl(doneSchemas, start2, decodedStart, (SchemaReference)imp);
                    }
                    catch (MalformedURLException e) {
                        if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                        this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, (SchemaReference)imp);
                this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List includes = CastUtils.cast((List)schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException start2) {
                // empty catch block
            }
            String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    this.checkSchemaUrl(doneSchemas, start, decodedStart, included);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
        }
        List redefines = CastUtils.cast((List)schema.getRedefines());
        for (SchemaReference included : redefines) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), (Throwable)e);
            }
            String resolvedSchemaLocation = WSDLQueryHandler.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    this.checkSchemaUrl(doneSchemas, start, decodedStart, included);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
        }
    }

    protected void checkSchemaUrl(Map<String, SchemaReference> doneSchemas, String start, String decodedStart, SchemaReference imp) throws MalformedURLException {
        new URL(start);
    }

    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo) {
        return this.isRecognizedQuery(baseUri, ctx, endpointInfo, false);
    }
}

