/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.support;

import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.FaultOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFaultOutInterceptor
extends FaultOutInterceptor {
    protected transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void handleMessage(Message message) throws Fault {
        Fault f = (Fault)message.getContent(Exception.class);
        Throwable cause = f.getCause();
        if (cause == null) {
            return;
        }
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop == null) {
            return;
        }
        FaultInfo fi = this.getFaultForClass(bop, cause.getClass());
        if (cause instanceof Exception && fi != null) {
            Exception ex = (Exception)cause;
            Object bean = this.getFaultBean(cause, fi, message);
            Service service = (Service)message.getExchange().get(Service.class);
            MessagePartInfo part = (MessagePartInfo)fi.getMessageParts().iterator().next();
            DataBinding db = service.getDataBinding();
            try {
                if (f.hasDetails()) {
                    W3CDOMStreamWriter xsw = new W3CDOMStreamWriter(f.getDetail());
                    DataWriter writer = db.createWriter(XMLStreamWriter.class);
                    writer.write(bean, part, (Object)xsw);
                } else {
                    W3CDOMStreamWriter xsw = new W3CDOMStreamWriter(f.getOrCreateDetail());
                    DataWriter writer = db.createWriter(XMLStreamWriter.class);
                    writer.write(bean, part, (Object)xsw);
                    if (!f.getDetail().hasChildNodes()) {
                        f.setDetail(null);
                    }
                }
                f.setMessage(ex.getMessage());
            }
            catch (Exception fex) {
                this.logger.warn("Exception while writing fault", (Throwable)fex);
            }
        }
    }

    public FaultInfo getFaultForClass(BindingOperationInfo op, Class class1) {
        for (BindingFaultInfo bfi : op.getFaults()) {
            FaultInfo faultInfo = bfi.getFaultInfo();
            Class c = (Class)faultInfo.getProperty(Class.class.getName());
            if (c == null || !c.isAssignableFrom(class1)) continue;
            return faultInfo;
        }
        return null;
    }
}

