/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.builder;

import javax.xml.namespace.QName;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.mule.compatibility.module.cxf.CxfInboundMessageProcessor;
import org.mule.compatibility.module.cxf.MuleJAXWSInvoker;
import org.mule.compatibility.module.cxf.builder.AbstractInboundMessageProcessorBuilder;
import org.mule.compatibility.module.cxf.i18n.CxfMessages;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.lifecycle.CreateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceMessageProcessorBuilder
extends AbstractInboundMessageProcessorBuilder
implements FlowConstructAware {
    protected transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DataBinding databinding;
    private String frontend = "jaxws";
    private Class<?> serviceClass;

    @Override
    protected ServerFactoryBean createServerFactory() throws Exception {
        ServerFactoryBean sfb;
        if ("simple".equals(this.frontend)) {
            sfb = new ServerFactoryBean();
            sfb.setDataBinding((DataBinding)new AegisDatabinding());
        } else if ("jaxws".equals(this.frontend)) {
            sfb = new JaxWsServerFactoryBean();
        } else {
            throw new CreateException(CxfMessages.invalidFrontend(this.frontend), (Object)this);
        }
        if (this.serviceClass == null) {
            throw new DefaultMuleException(CxfMessages.serviceClassRequiredWithPassThrough());
        }
        sfb.setServiceClass(this.serviceClass);
        this.logger.info("Built CXF Inbound MessageProcessor for service class " + this.serviceClass.getName());
        if (this.databinding != null) {
            sfb.setDataBinding(this.databinding);
        }
        if (this.getService() != null && this.getNamespace() != null) {
            sfb.setServiceName(new QName(this.getNamespace(), this.getService()));
        }
        return sfb;
    }

    @Override
    protected Invoker createInvoker(CxfInboundMessageProcessor processor, FlowConstruct flowConstruct) {
        Object invoker = super.createInvoker(processor, flowConstruct);
        if ("jaxws".equals(this.frontend)) {
            invoker = new MuleJAXWSInvoker((Invoker)invoker);
        }
        return invoker;
    }

    @Override
    protected String getAddress() {
        return "http://internalMuleCxfRegistry/" + ((Object)((Object)this)).hashCode();
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getFrontend() {
        return this.frontend;
    }

    public void setFrontend(String frontend) {
        this.frontend = frontend;
    }

    public DataBinding getDatabinding() {
        return this.databinding;
    }

    public void setDatabinding(DataBinding databinding) {
        this.databinding = databinding;
    }
}

