/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.builder;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.mule.compatibility.module.cxf.CxfConfiguration;
import org.mule.compatibility.module.cxf.CxfOutboundMessageProcessor;
import org.mule.compatibility.module.cxf.CxfPayloadToArguments;
import org.mule.compatibility.module.cxf.config.WsSecurity;
import org.mule.compatibility.module.cxf.support.MuleHeadersInInterceptor;
import org.mule.compatibility.module.cxf.support.MuleHeadersOutInterceptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.CreateException;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;

public abstract class AbstractOutboundMessageProcessorBuilder
implements MessageProcessorBuilder,
MuleContextAware {
    protected Client client;
    protected String defaultMethodName;
    protected Method defaultMethod;
    protected CxfConfiguration configuration;
    protected List<Interceptor<? extends Message>> inInterceptors;
    protected List<Interceptor<? extends Message>> inFaultInterceptors;
    protected List<Interceptor<? extends Message>> outInterceptors;
    protected List<Interceptor<? extends Message>> outFaultInterceptors;
    protected DataBinding databinding;
    protected List<AbstractFeature> features;
    protected String wsdlLocation;
    protected boolean mtomEnabled;
    protected String soapVersion;
    protected boolean enableMuleSoapHeaders = true;
    protected CxfPayloadToArguments payloadToArguments = CxfPayloadToArguments.NULL_PAYLOAD_AS_PARAMETER;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected MuleContext muleContext;
    protected String address;
    protected String operation;
    protected String decoupledEndpoint;
    private WsSecurity wsSecurity;

    public CxfOutboundMessageProcessor build() {
        if (this.muleContext == null) {
            throw new IllegalStateException("MuleContext must be supplied.");
        }
        try {
            if (this.configuration == null) {
                this.configuration = CxfConfiguration.getConfiguration(this.muleContext);
            }
            BusFactory.setThreadDefaultBus((Bus)this.getBus());
            this.client = this.createClient();
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        this.addInterceptors(this.client.getInInterceptors(), this.inInterceptors);
        this.addInterceptors(this.client.getInFaultInterceptors(), this.inFaultInterceptors);
        this.addInterceptors(this.client.getOutInterceptors(), this.outInterceptors);
        this.addInterceptors(this.client.getOutFaultInterceptors(), this.outFaultInterceptors);
        this.client.setThreadLocalRequestContext(true);
        if (this.wsSecurity != null && this.wsSecurity.getConfigProperties() != null && !this.wsSecurity.getConfigProperties().isEmpty()) {
            this.client.getOutInterceptors().add(new WSS4JOutInterceptor(this.wsSecurity.getConfigProperties()));
        }
        this.configureClient(this.client);
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                f.initialize(this.client, this.getBus());
            }
        }
        if (this.mtomEnabled) {
            this.client.getEndpoint().put((Object)"mtom-enabled", (Object)this.mtomEnabled);
        }
        this.addMuleInterceptors();
        CxfOutboundMessageProcessor processor = this.createMessageProcessor();
        processor.setOperation(this.operation);
        this.configureMessageProcessor(processor);
        processor.setPayloadToArguments(this.payloadToArguments);
        processor.setMimeType(this.getMimeType());
        return processor;
    }

    protected CxfOutboundMessageProcessor createMessageProcessor() {
        CxfOutboundMessageProcessor processor = new CxfOutboundMessageProcessor(this.client);
        processor.setMuleContext(this.muleContext);
        return processor;
    }

    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
    }

    protected void configureClient(Client client) {
    }

    protected Bus getBus() {
        return this.configuration.getCxfBus();
    }

    protected abstract Client createClient() throws CreateException, Exception;

    public Client getClient() {
        return this.client;
    }

    private void addInterceptors(List<Interceptor<? extends Message>> col, List<Interceptor<? extends Message>> supplied) {
        if (supplied != null) {
            col.addAll(supplied);
        }
    }

    protected String getAddress() {
        if (this.address == null) {
            return "http://host";
        }
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    protected void createClientFromLocalServer() throws Exception {
    }

    protected void addMuleInterceptors() {
        if (this.enableMuleSoapHeaders && !this.configuration.isEnableMuleSoapHeaders()) {
            this.client.getInInterceptors().add(new MuleHeadersInInterceptor());
            this.client.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
            this.client.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            this.client.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public DataBinding getDatabinding() {
        return this.databinding;
    }

    public void setDatabinding(DataBinding databinding) {
        this.databinding = databinding;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.inInterceptors;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> inInterceptors) {
        this.inInterceptors = inInterceptors;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> inFaultInterceptors) {
        this.inFaultInterceptors = inFaultInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.outInterceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> outInterceptors) {
        this.outInterceptors = outInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> outFaultInterceptors) {
        this.outFaultInterceptors = outFaultInterceptors;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public CxfConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CxfConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnableMuleSoapHeaders() {
        return this.enableMuleSoapHeaders;
    }

    public void setEnableMuleSoapHeaders(boolean enableMuleSoapHeaders) {
        this.enableMuleSoapHeaders = enableMuleSoapHeaders;
    }

    public CxfPayloadToArguments getPayloadToArguments() {
        return this.payloadToArguments;
    }

    public void setPayloadToArguments(CxfPayloadToArguments payloadToArguments) {
        this.payloadToArguments = payloadToArguments;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setAddProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public void setDecoupledEndpoint(String decoupledEndpoint) {
        this.decoupledEndpoint = decoupledEndpoint;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setWsSecurity(WsSecurity wsSecurity) {
        this.wsSecurity = wsSecurity;
    }

    protected MediaType getMimeType() {
        return MediaType.ANY;
    }
}

