/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf;

import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.util.StringUtils;

public class HttpRequestPropertyManager {
    public String getRequestPath(InternalMessage message) {
        String requestUri = (String)((Object)message.getInboundProperty("http.request.uri"));
        if (requestUri == null && message.getAttributes() instanceof HttpRequestAttributes) {
            requestUri = ((HttpRequestAttributes)message.getAttributes()).getRequestUri();
        }
        return requestUri != null ? requestUri : "";
    }

    public String getScheme(Event event) {
        String scheme = (String)((Object)event.getMessage().getInboundProperty("http.scheme"));
        if (scheme == null && event.getMessage().getAttributes() instanceof HttpRequestAttributes) {
            scheme = ((HttpRequestAttributes)event.getMessage().getAttributes()).getScheme();
        }
        return scheme;
    }

    public String getBasePath(InternalMessage message) {
        String requestPath;
        String listenerPath = (String)((Object)message.getInboundProperty("http.listener.path"));
        if (listenerPath == null && message.getAttributes() instanceof HttpRequestAttributes) {
            listenerPath = ((HttpRequestAttributes)message.getAttributes()).getListenerPath();
        }
        if ((requestPath = (String)((Object)message.getInboundProperty("http.request.path"))) == null && message.getAttributes() instanceof HttpRequestAttributes) {
            requestPath = ((HttpRequestAttributes)message.getAttributes()).getRequestPath();
        }
        if (listenerPath.contains(requestPath)) {
            return requestPath;
        }
        int slashCount = StringUtils.countMatches((String)listenerPath, (String)"/");
        int matchPrefixIndex = StringUtils.ordinalIndexOf((String)requestPath, (String)"/", (int)slashCount);
        return requestPath.substring(0, matchPrefixIndex);
    }
}

