/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.wsdl.http.AddressType;
import org.mule.compatibility.module.cxf.HttpRequestPropertyManager;
import org.mule.compatibility.module.cxf.support.DelegatingOutputStream;
import org.mule.compatibility.module.cxf.transport.MuleUniversalDestination;
import org.mule.extension.http.api.HttpAttributes;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.DefaultExceptionPayload;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.module.xml.stax.StaxSource;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CxfInboundMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Lifecycle {
    private static final String HTTP_REQUEST_PROPERTY_MANAGER_KEY = "_cxfHttpRequestPropertyManager";
    public static final String JMS_TRANSPORT = "jms";
    protected transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Bus bus;
    protected String transportClass;
    protected Server server;
    private boolean proxy;
    private QueryHandler wsdlQueryHandler;
    private MediaType mimeType;
    private HttpRequestPropertyManager requestPropertyManager;

    public void initialise() throws InitialisationException {
        if (this.bus == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"No CXF bus instance, this component has not been initialized properly."), (Initialisable)this);
        }
        HttpRequestPropertyManager httpRequestPropertyManager = (HttpRequestPropertyManager)this.muleContext.getRegistry().get(HTTP_REQUEST_PROPERTY_MANAGER_KEY);
        this.requestPropertyManager = httpRequestPropertyManager != null ? httpRequestPropertyManager : new HttpRequestPropertyManager();
    }

    public void stop() throws MuleException {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void start() throws MuleException {
        if (this.server != null) {
            this.server.start();
        }
    }

    public void dispose() {
    }

    public Event process(Event event) throws MuleException {
        String requestPath = this.parseHttpRequestProperty(this.requestPropertyManager.getRequestPath(event.getMessage()));
        try {
            if (requestPath.indexOf(63) > -1) {
                return this.generateWSDLOrXSD(event, requestPath);
            }
            return this.sendToDestination(event);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private String parseHttpRequestProperty(String request) {
        String uriBase = "";
        if (!request.contains("?wsdl") && !request.contains("?xsd")) {
            int qIdx = request.indexOf(63);
            if (qIdx > -1) {
                uriBase = request.substring(0, qIdx);
            }
        } else {
            uriBase = request;
        }
        return uriBase;
    }

    protected Event generateWSDLOrXSD(Event event, String req) throws IOException {
        String message;
        String ctxUri = this.requestPropertyManager.getBasePath(event.getMessage());
        String wsdlUri = this.getUri(event);
        String serviceUri = wsdlUri.substring(0, wsdlUri.indexOf(63));
        EndpointInfo ei = this.getServer().getEndpoint().getEndpointInfo();
        if (serviceUri != null) {
            ei.setAddress(serviceUri);
            if (ei.getExtensor(AddressType.class) != null) {
                ((AddressType)ei.getExtensor(AddressType.class)).setLocation(serviceUri);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MediaType ct = null;
        if (this.wsdlQueryHandler.isRecognizedQuery(wsdlUri, ctxUri, ei)) {
            ct = MediaType.parse((String)this.wsdlQueryHandler.getResponseContentType(wsdlUri, ctxUri));
            this.wsdlQueryHandler.writeResponse(wsdlUri, ctxUri, ei, (OutputStream)out);
            out.flush();
        }
        if (ct == null) {
            ct = MediaType.TEXT;
            message = "No query handler found for URL.";
        } else {
            message = out.toString();
        }
        return Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)message).mediaType(ct).build()).build();
    }

    private String getUri(Event event) {
        String scheme = this.requestPropertyManager.getScheme(event);
        String host = (String)((Object)event.getMessage().getInboundProperty("Host"));
        if (host == null && event.getMessage().getAttributes() instanceof HttpRequestAttributes) {
            host = ((HttpRequestAttributes)event.getMessage().getAttributes()).getHeaders().get((Object)"Host".toLowerCase());
        }
        String ctx = this.requestPropertyManager.getRequestPath(event.getMessage());
        return scheme + "://" + host + ctx;
    }

    protected Event sendToDestination(Event event) throws MuleException, IOException {
        try {
            ExchangeImpl exchange = new ExchangeImpl();
            return this.processResponse(event, (Exchange)exchange, this.sendThroughCxf(event, (Exchange)exchange));
        }
        catch (MuleException e) {
            this.logger.warn("Could not dispatch message to CXF!", (Throwable)e);
            throw e;
        }
    }

    private Event sendThroughCxf(Event event, Exchange exchange) throws TransformerException, IOException {
        Destination d;
        String path;
        MediaType ct;
        MessageImpl m = new MessageImpl();
        m.setExchange(exchange);
        InternalMessage muleReqMsg = event.getMessage();
        String method = (String)((Object)muleReqMsg.getInboundProperty("http.method"));
        if (method == null && muleReqMsg.getAttributes() instanceof HttpRequestAttributes) {
            method = ((HttpRequestAttributes)muleReqMsg.getAttributes()).getMethod();
        }
        if (!(ct = muleReqMsg.getPayload().getDataType().getMediaType()).matches(MediaType.ANY)) {
            m.put("Content-Type", (Object)ct.toRfcString());
        }
        if ((path = this.requestPropertyManager.getRequestPath(event.getMessage())) == null) {
            path = "";
        }
        if (method != null) {
            m.put("org.apache.cxf.request.method", (Object)method);
            m.put(org.apache.cxf.message.Message.PATH_INFO, (Object)path);
            String basePath = this.requestPropertyManager.getBasePath(muleReqMsg);
            m.put(org.apache.cxf.message.Message.BASE_PATH, (Object)basePath);
            method = method.toUpperCase();
        }
        if (!"GET".equals(method)) {
            Object payload = event.getMessage().getPayload().getValue();
            this.setPayload(event, m, payload);
        }
        String soapAction = this.getSoapAction(event.getMessage());
        m.put("SOAPAction", (Object)soapAction);
        if (this.server != null) {
            d = this.server.getDestination();
        } else {
            String serviceUri = this.getUri(event);
            DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
            DestinationFactory df = dfm.getDestinationFactoryForUri(serviceUri);
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress(serviceUri);
            d = df.getDestination(ei);
        }
        if (this.shouldSoapActionHeader()) {
            HashMap<String, List<Object>> protocolHeaders = new HashMap<String, List<Object>>();
            if (soapAction != null && !soapAction.isEmpty()) {
                ArrayList<String> soapActions = new ArrayList<String>();
                soapActions.add(soapAction);
                protocolHeaders.put("SOAPAction", soapActions);
            }
            if ("http://www.w3.org/2010/soapjms/".equals(((MuleUniversalDestination)d).getEndpointInfo().getTransportId())) {
                String contentType = (String)((Object)muleReqMsg.getInboundProperty("SOAPJMS_contentType"));
                if (contentType == null) {
                    contentType = MediaType.XML.toRfcString();
                }
                protocolHeaders.put("SOAPJMS_contentType", Collections.singletonList(contentType));
                String requestUri = (String)((Object)muleReqMsg.getInboundProperty("SOAPJMS_requestURI"));
                if (requestUri == null) {
                    if (muleReqMsg.getAttributes() instanceof HttpRequestAttributes) {
                        HttpRequestAttributes httpRequestAttributes = (HttpRequestAttributes)muleReqMsg.getAttributes();
                        requestUri = httpRequestAttributes.getScheme() + "://" + httpRequestAttributes.getHeaders().get((Object)"host") + httpRequestAttributes.getRequestUri();
                    } else {
                        requestUri = muleReqMsg.getInboundProperty("http.scheme") + "://" + muleReqMsg.getInboundProperty("host") + muleReqMsg.getInboundProperty("http.request.uri");
                    }
                }
                protocolHeaders.put("SOAPJMS_requestURI", Collections.singletonList(requestUri));
            }
            m.put(org.apache.cxf.message.Message.PROTOCOL_HEADERS, protocolHeaders);
        }
        m.put(LocalConduit.DIRECT_DISPATCH, (Object)Boolean.TRUE);
        m.setDestination(d);
        exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        exchange.setInMessage((org.apache.cxf.message.Message)m);
        exchange.put((Object)"mule.event", (Object)event);
        try {
            d.getMessageObserver().onMessage((org.apache.cxf.message.Message)m);
        }
        catch (SuspendedInvocationException e) {
            Event responseEvent = (Event)exchange.get((Object)"mule.event");
            throw e;
        }
        return (Event)exchange.get((Object)"mule.event");
    }

    private Event processResponse(Event event, Exchange exchange, Event responseEvent) {
        if (responseEvent == null) {
            return null;
        }
        InternalMessage message = responseEvent.getMessage();
        InternalMessage.Builder builder = InternalMessage.builder((Message)message);
        BindingOperationInfo binding = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        HttpConstants.HttpStatus responseCode = HttpConstants.HttpStatus.OK;
        ParameterMap responseParams = new ParameterMap();
        if (message.getAttributes() instanceof HttpResponseAttributes) {
            responseCode = HttpConstants.HttpStatus.getStatusByCode((int)((HttpResponseAttributes)message.getAttributes()).getStatusCode());
            responseParams.putAll((Map)((HttpResponseAttributes)message.getAttributes()).getHeaders());
        }
        if (null != binding && null != binding.getOperationInfo() && binding.getOperationInfo().isOneWay()) {
            builder.addOutboundProperty("http.status", (Serializable)Integer.valueOf(HttpConstants.HttpStatus.ACCEPTED.getStatusCode()));
            responseCode = HttpConstants.HttpStatus.ACCEPTED;
            builder.nullPayload();
        } else {
            Optional charset = message.getPayload().getDataType().getMediaType().getCharset();
            if (charset.isPresent()) {
                builder.payload((Object)this.getResponseOutputHandler(exchange)).mediaType(message.getPayload().getDataType().getMediaType().withCharset((Charset)charset.get()));
            } else {
                String ct = (String)exchange.get((Object)"Content-Type");
                MediaType mediaType = ct != null ? MediaType.parse((String)ct) : message.getPayload().getDataType().getMediaType();
                builder.payload((Object)this.getResponseOutputHandler(exchange)).mediaType(mediaType);
            }
        }
        org.apache.cxf.message.Message faultMsg = exchange.getOutFaultMessage();
        if (faultMsg != null) {
            Exception ex;
            if (null != binding && null != binding.getOperationInfo() && binding.getOperationInfo().isOneWay()) {
                Optional charset = message.getPayload().getDataType().getMediaType().getCharset();
                if (charset.isPresent()) {
                    builder.payload((Object)this.getResponseOutputHandler(exchange)).mediaType(MediaType.XML.withCharset((Charset)charset.get()));
                } else {
                    builder.payload((Object)this.getResponseOutputHandler(exchange)).mediaType(MediaType.XML);
                }
            }
            if ((ex = (Exception)faultMsg.getContent(Exception.class)) != null) {
                builder.exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)ex));
                builder.addOutboundProperty("http.status", (Serializable)Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
                responseCode = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR;
            }
        }
        InternalMessage responseMessage = builder.attributes((Attributes)new HttpResponseAttributes(responseCode.getStatusCode(), responseCode.getReasonPhrase(), responseParams)).build();
        return Event.builder((Event)responseEvent).message((Message)responseMessage).build();
    }

    protected boolean shouldSoapActionHeader() {
        boolean isGenericProxy = "http://support.cxf.module.compatibility.mule.org/".equals(this.getServer().getEndpoint().getService().getName().getNamespaceURI()) && "ProxyService".equals(this.getServer().getEndpoint().getService().getName().getLocalPart());
        return !isGenericProxy;
    }

    public Event processNext(Event event) throws MuleException {
        return super.processNext(event);
    }

    @Deprecated
    protected OutputHandler getRessponseOutputHandler(MessageImpl m) {
        return this.getResponseOutputHandler(m);
    }

    protected OutputHandler getResponseOutputHandler(MessageImpl m) {
        return this.getResponseOutputHandler(m.getExchange());
    }

    protected OutputHandler getResponseOutputHandler(Exchange exchange) {
        OutputHandler outputHandler = (event, out) -> {
            org.apache.cxf.message.Message outFaultMessage = exchange.getOutFaultMessage();
            org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
            org.apache.cxf.message.Message contentMsg = null;
            if (outFaultMessage != null && outFaultMessage.getContent(OutputStream.class) != null) {
                contentMsg = outFaultMessage;
            } else if (outMessage != null) {
                contentMsg = outMessage;
            }
            if (contentMsg == null) {
                return;
            }
            DelegatingOutputStream delegate = (DelegatingOutputStream)contentMsg.getContent(DelegatingOutputStream.class);
            if (delegate.getOutputStream() instanceof ByteArrayOutputStream) {
                out.write(((ByteArrayOutputStream)delegate.getOutputStream()).toByteArray());
            }
            delegate.setOutputStream(out);
            out.flush();
            contentMsg.getInterceptorChain().resume();
        };
        return outputHandler;
    }

    private void setPayload(Event ctx, MessageImpl m, Object payload) throws TransformerException {
        if (payload instanceof Reader) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Reader)((Reader)payload)));
        } else if (payload instanceof byte[]) {
            m.setContent(InputStream.class, (Object)new ByteArrayInputStream((byte[])payload));
        } else if (payload instanceof StaxSource) {
            m.setContent(XMLStreamReader.class, (Object)((StaxSource)payload).getXMLStreamReader());
        } else if (payload instanceof Source) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)((Source)payload)));
        } else if (payload instanceof XMLStreamReader) {
            m.setContent(XMLStreamReader.class, payload);
        } else if (payload instanceof Document) {
            DOMSource source = new DOMSource((Node)payload);
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)source));
        } else {
            ctx.getMessage().getPayload().getDataType().getMediaType().getCharset().ifPresent(encoding -> m.put(org.apache.cxf.message.Message.ENCODING, (Object)encoding.name()));
            if (payload instanceof CursorStreamProvider) {
                m.setContent(InputStream.class, (Object)((CursorStreamProvider)payload).openCursor());
            } else if (payload instanceof InputStream) {
                m.setContent(InputStream.class, payload);
            } else {
                InputStream is = (InputStream)ctx.transformMessage(DataType.INPUT_STREAM, this.muleContext);
                m.setContent(InputStream.class, (Object)is);
            }
        }
    }

    protected InputStream getMessageStream(Event context) throws MuleException {
        Object eventMsgPayload = context.getMessage().getPayload().getValue();
        InputStream is = eventMsgPayload instanceof InputStream ? (InputStream)eventMsgPayload : (InputStream)context.transformMessage(DataType.INPUT_STREAM, this.muleContext);
        return is;
    }

    protected String getSoapAction(InternalMessage message) {
        String action = (String)((Object)message.getInboundProperty("soapAction"));
        if (action == null && message.getAttributes() instanceof HttpAttributes) {
            action = ((HttpAttributes)message.getAttributes()).getHeaders().get((Object)"soapAction".toLowerCase());
        }
        if (action != null && action.startsWith("\"") && action.endsWith("\"") && action.length() >= 2) {
            action = action.substring(1, action.length() - 1);
        }
        return action;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setWSDLQueryHandler(QueryHandler wsdlQueryHandler) {
        this.wsdlQueryHandler = wsdlQueryHandler;
    }

    public MediaType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MediaType mimeType) {
        this.mimeType = mimeType;
    }
}

