/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.support;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

public class StaxFeature
extends AbstractFeature {
    private String xmlInputFactory;
    private String xmlOutputFactory;

    public void initialize(Client client, Bus bus) {
        Service service = client.getEndpoint().getService();
        this.setProperties(service);
    }

    private void setProperties(Service service) {
        if (this.xmlInputFactory != null) {
            service.put((Object)XMLInputFactory.class.getName(), (Object)this.xmlInputFactory);
        }
        if (this.xmlOutputFactory != null) {
            service.put((Object)XMLOutputFactory.class.getName(), (Object)this.xmlOutputFactory);
        }
    }

    public void initialize(Server server, Bus bus) {
        Service service = server.getEndpoint().getService();
        this.setProperties(service);
    }

    public void initialize(Bus bus) {
        AbstractPhaseInterceptor<Message> in = new AbstractPhaseInterceptor<Message>("receive"){

            public void handleMessage(Message message) throws Fault {
                if (StaxFeature.this.xmlInputFactory != null) {
                    message.put((Object)XMLInputFactory.class.getName(), (Object)StaxFeature.this.xmlInputFactory);
                }
            }
        };
        bus.getInInterceptors().add(in);
        bus.getInFaultInterceptors().add(in);
        AbstractPhaseInterceptor<Message> out = new AbstractPhaseInterceptor<Message>("setup"){

            public void handleMessage(Message message) throws Fault {
                if (StaxFeature.this.xmlOutputFactory != null) {
                    message.put((Object)XMLOutputFactory.class.getName(), (Object)StaxFeature.this.xmlOutputFactory);
                }
            }
        };
        bus.getOutInterceptors().add(out);
        bus.getOutFaultInterceptors().add(out);
    }

    public String getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXmlInputFactory(String xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
    }

    public String getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    public void setXmlOutputFactory(String xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }
}

