/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.support;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.wsdl.WSDLManager;
import org.mule.runtime.module.cxf.i18n.CxfMessages;
import org.mule.runtime.module.cxf.support.ComponentNotFoundRuntimeException;
import org.mule.runtime.module.cxf.support.ProxyServiceFactoryBean;

public class ProxyServiceConfiguration
extends DefaultServiceConfiguration {
    private static final Logger LOG = LogUtils.getLogger(ProxyServiceFactoryBean.class);
    private String soapVersion;

    public QName getEndpointName() {
        try {
            if (this.getServiceFactory().getWsdlURL() != null) {
                Definition definition = ((WSDLManager)this.getServiceFactory().getBus().getExtension(WSDLManager.class)).getDefinition(this.getServiceFactory().getWsdlURL());
                Service service = this.getServiceFromDefinition(definition);
                this.setServiceNamespace(service.getQName().getNamespaceURI());
                QName endpointName = this.getPortMatchingSoapVersion(service);
                if (endpointName == null) {
                    endpointName = new QName(this.getServiceNamespace(), ((Port)service.getPorts().values().iterator().next()).getName());
                }
                LOG.fine(String.format("ProxyServiceConfiguration using endpoint %s", endpointName));
                return endpointName;
            }
            return super.getEndpointName();
        }
        catch (WSDLException e) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), (Throwable)e);
        }
    }

    private QName getPortMatchingSoapVersion(Service service) {
        if (this.soapVersion == null) {
            return null;
        }
        for (Port port : service.getPorts().values()) {
            for (Object element : port.getBinding().getExtensibilityElements()) {
                if ((!(element instanceof SOAPBinding) || !"1.1".equals(this.soapVersion)) && (!(element instanceof SOAP12Binding) || !"1.2".equals(this.soapVersion))) continue;
                return new QName(this.getServiceNamespace(), port.getName());
            }
        }
        return null;
    }

    protected Service getServiceFromDefinition(Definition definition) {
        Service service = definition.getService(this.getServiceFactory().getServiceQName());
        if (service == null) {
            List<QName> probableServices = this.getProbableServices(definition);
            List<QName> allServices = this.getAllServices(definition);
            throw new ComponentNotFoundRuntimeException(CxfMessages.invalidOrMissingNamespace(this.getServiceFactory().getServiceQName(), probableServices, allServices));
        }
        return service;
    }

    protected List<QName> getAllServices(Definition definition) {
        return new LinkedList<QName>(CollectionUtils.select(definition.getServices().keySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof QName;
            }
        }));
    }

    protected List<QName> getProbableServices(Definition definition) {
        QName serviceQName = this.getServiceFactory().getServiceQName();
        LinkedList<QName> probableServices = new LinkedList<QName>();
        Map services = definition.getServices();
        for (Object key : services.keySet()) {
            QName qNameKey;
            if (!(key instanceof QName) || (qNameKey = (QName)key).getLocalPart() == null || !qNameKey.getLocalPart().equals(serviceQName.getLocalPart())) continue;
            probableServices.add(qNameKey);
        }
        return probableServices;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }
}

