/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.support;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.security.Authentication;
import org.mule.runtime.core.api.security.Credentials;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.core.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.security.DefaultMuleAuthentication;
import org.mule.runtime.core.security.MuleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSecurityManagerValidator
implements Validator {
    private static Logger logger = LoggerFactory.getLogger(MuleSecurityManagerValidator.class);
    private SecurityManager securityManager;

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        DefaultMuleAuthentication auth = new DefaultMuleAuthentication((Credentials)new MuleCredentials(credential.getUsernametoken().getName(), credential.getUsernametoken().getPassword().toCharArray()));
        try {
            Authentication authentication = this.securityManager.authenticate((Authentication)auth);
            SecurityContext secContext = null;
            try {
                secContext = this.securityManager.createSecurityContext(authentication);
                secContext.setAuthentication(authentication);
            }
            catch (UnknownAuthenticationTypeException e) {
                logger.warn("Could not create security context after having successfully authenticated.", (Throwable)e);
            }
            Event.getCurrentEvent().getSession().setSecurityContext(secContext);
        }
        catch (SecurityException e) {
            throw new WSSecurityException(5, null, null, (Throwable)e);
        }
        catch (SecurityProviderNotFoundException e) {
            throw new WSSecurityException(5, null, null, (Throwable)e);
        }
        return credential;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }
}

