/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.builder;

import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transports.http.QueryHandler;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.module.cxf.builder.AbstractInboundMessageProcessorBuilder;
import org.mule.runtime.module.cxf.support.CopyAttachmentInInterceptor;
import org.mule.runtime.module.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.runtime.module.cxf.support.CxfUtils;
import org.mule.runtime.module.cxf.support.OutputPayloadInterceptor;
import org.mule.runtime.module.cxf.support.ProxyRPCInInterceptor;
import org.mule.runtime.module.cxf.support.ProxySchemaValidationInInterceptor;
import org.mule.runtime.module.cxf.support.ProxyService;
import org.mule.runtime.module.cxf.support.ProxyServiceFactoryBean;
import org.mule.runtime.module.cxf.support.ProxyWSDLQueryHandler;
import org.mule.runtime.module.cxf.support.ResetStaxInterceptor;
import org.mule.runtime.module.cxf.support.ReversibleStaxInInterceptor;
import org.mule.runtime.module.cxf.support.ReversibleValidatingInterceptor;

public class ProxyServiceMessageProcessorBuilder
extends AbstractInboundMessageProcessorBuilder {
    private String payload;

    @Override
    protected ServerFactoryBean createServerFactory() throws Exception {
        ServerFactoryBean sfb = new ServerFactoryBean();
        sfb.setDataBinding((DataBinding)new StaxDataBinding());
        sfb.getFeatures().add(new StaxDataBindingFeature());
        ProxyServiceFactoryBean proxyServiceFactoryBean = new ProxyServiceFactoryBean();
        proxyServiceFactoryBean.setSoapVersion(this.getSoapVersion());
        sfb.setServiceFactory((ReflectionServiceFactoryBean)proxyServiceFactoryBean);
        sfb.setServiceClass(ProxyService.class);
        this.addProxyInterceptors(sfb);
        return sfb;
    }

    @Override
    protected Class<?> getServiceClass() {
        return ProxyService.class;
    }

    @Override
    protected QueryHandler getWSDLQueryHandler() {
        return new ProxyWSDLQueryHandler(this.getConfiguration().getCxfBus(), this.getPort());
    }

    @Override
    protected void configureServer(Server server) {
        if (this.isProxyEnvelope()) {
            CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getOutInterceptors(), SoapOutInterceptor.class.getName());
        }
        CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getInInterceptors(), MustUnderstandInterceptor.class.getName());
        this.replaceRPCInterceptors(server);
        if (this.isValidationEnabled()) {
            server.getEndpoint().getInInterceptors().add(new ProxySchemaValidationInInterceptor(this.getConfiguration().getCxfBus(), server.getEndpoint(), (ServiceInfo)server.getEndpoint().getService().getServiceInfos().get(0)));
        }
    }

    private void replaceRPCInterceptors(Server server) {
        if (CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getInInterceptors(), RPCInInterceptor.class.getName())) {
            server.getEndpoint().getBinding().getInInterceptors().add(new ProxyRPCInInterceptor());
        }
        if (CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getOutInterceptors(), RPCOutInterceptor.class.getName())) {
            server.getEndpoint().getBinding().getOutInterceptors().add(new BareOutInterceptor());
        }
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    protected void addProxyInterceptors(ServerFactoryBean sfb) {
        sfb.getOutInterceptors().add(new OutputPayloadInterceptor(this.muleContext.getTransformationService()));
        sfb.getInInterceptors().add(new CopyAttachmentInInterceptor());
        sfb.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
        if (this.isProxyEnvelope()) {
            sfb.getInInterceptors().add(new ReversibleStaxInInterceptor());
            sfb.getInInterceptors().add(new ResetStaxInterceptor());
        } else if (this.isValidationEnabled()) {
            sfb.getInInterceptors().add(new ReversibleValidatingInterceptor());
            sfb.getInInterceptors().add(new ResetStaxInterceptor());
        }
    }

    public boolean isProxyEnvelope() {
        return "envelope".equals(this.payload);
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Override
    protected MediaType getMimeType() {
        return MediaType.XML;
    }
}

