/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.script.ScriptException;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.component.ComponentException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ErrorHandlingExecutionTemplate;
import org.mule.runtime.module.cxf.CxfInboundMessageProcessor;

public class MuleInvoker
implements Invoker {
    private final CxfInboundMessageProcessor cxfMmessageProcessor;
    private Class<?> targetClass;
    private FlowConstruct flowConstruct;

    public MuleInvoker(CxfInboundMessageProcessor cxfMmessageProcessor, Class<?> targetClass, FlowConstruct flowConstruct) {
        this.cxfMmessageProcessor = cxfMmessageProcessor;
        this.targetClass = targetClass;
        this.flowConstruct = flowConstruct;
    }

    public Object invoke(Exchange exchange, Object o) {
        Event event = (Event)exchange.get((Object)"mule.event");
        Event responseEvent = null;
        Event.Builder responseBuilder = Event.builder((Event)event);
        try {
            Object payload = this.extractPayload(exchange.getInMessage());
            responseBuilder.message(InternalMessage.builder((InternalMessage)event.getMessage()).payload(payload).mediaType(this.cxfMmessageProcessor.getMimeType()).build());
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            Service svc = (Service)exchange.get(Service.class);
            if (!this.cxfMmessageProcessor.isProxy()) {
                MethodDispatcher md = (MethodDispatcher)svc.get((Object)MethodDispatcher.class.getName());
                Method m = md.getMethod(bop);
                if (this.targetClass != null) {
                    m = MuleInvoker.matchMethod(m, this.targetClass);
                }
                responseBuilder.addVariable("method", (Object)m);
            }
            if (bop != null) {
                responseBuilder.addVariable("cxf_operation", (Object)bop.getOperationInfo().getName()).addVariable("cxf_service", (Object)svc.getName());
            }
            ErrorHandlingExecutionTemplate errorHandlingExecutionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate((MuleContext)this.flowConstruct.getMuleContext(), (FlowConstruct)this.flowConstruct, (MessagingExceptionHandler)this.flowConstruct.getExceptionListener());
            Event finalEvent = event = responseBuilder.build();
            responseEvent = errorHandlingExecutionTemplate.execute(() -> this.cxfMmessageProcessor.processNext(finalEvent));
        }
        catch (MuleException e) {
            event = responseBuilder.build();
            exchange.put((Object)"mule.event", (Object)event);
            Throwable cause = e;
            String unwrapMuleExceptions = (String)Event.getVariableValueOrNull((String)"unwrapMuleExceptions", (Event)event);
            if (Boolean.valueOf(unwrapMuleExceptions).booleanValue()) {
                cause = ExceptionHelper.getNonMuleException((Throwable)e);
                if (cause instanceof ScriptException && cause.getCause() != null) {
                    cause = cause.getCause();
                }
            } else if (e instanceof MessagingException && e.getCause() != null && (cause = e.getCause()) instanceof ComponentException) {
                cause = cause.getCause();
            }
            throw new Fault(cause);
        }
        catch (Exception e) {
            exchange.put((Object)"mule.event", (Object)responseBuilder.build());
            throw new Fault((Throwable)e);
        }
        if (!event.getExchangePattern().hasResponse()) {
            responseEvent = null;
        }
        if (responseEvent != null) {
            exchange.put((Object)"mule.event", (Object)responseEvent);
            InternalMessage resMessage = responseEvent.getMessage();
            if (responseEvent.getError().isPresent()) {
                Throwable cause = ((Error)responseEvent.getError().get()).getCause();
                if (cause instanceof ComponentException) {
                    cause = cause.getCause();
                }
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                if (cause instanceof Fault) {
                    throw (Fault)cause;
                }
                throw new Fault(cause);
            }
            if (resMessage.getPayload().getValue() == null) {
                return new MessageContentsList(new Object[]{null});
            }
            if (this.cxfMmessageProcessor.isProxy()) {
                resMessage.getPayload().getValue();
                return new Object[]{resMessage};
            }
            return new Object[]{resMessage.getPayload().getValue()};
        }
        exchange.getInMessage().getInterceptorChain().abort();
        if (exchange.getOutMessage() != null) {
            exchange.getOutMessage().getInterceptorChain().abort();
        }
        exchange.put((Object)"mule.event", null);
        return null;
    }

    protected Object extractPayload(Message cxfMessage) {
        List list = CastUtils.cast((List)((List)cxfMessage.getContent(List.class)));
        if (list == null) {
            Object object = cxfMessage.getContent(Object.class);
            if (object != null) {
                return object;
            }
            return new Object[0];
        }
        if (list.size() == 1 && list.get(0) != null) {
            return list.get(0);
        }
        return list.toArray();
    }

    private static Method matchMethod(Method methodToMatch, Class<?> targetClass) {
        for (Class<?> iface : targetClass.getInterfaces()) {
            Method m = MuleInvoker.getMostSpecificMethod(methodToMatch, iface);
            if (methodToMatch.equals(m)) continue;
            return m;
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

