/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.util.StringUtils;

public class HttpRequestPropertyManager {
    public static String getRequestPath(MuleMessage message) {
        String requestPath = (String)message.getInboundProperty("http.request", (Object)"");
        if (requestPath.equals("")) {
            requestPath = (String)message.getInboundProperty("http.request.uri", (Object)"");
        }
        return requestPath;
    }

    public static String getScheme(MuleEvent event) {
        String scheme = event.getMessageSourceURI().getScheme();
        if (scheme == null) {
            scheme = (String)event.getMessage().getInboundProperty("http.scheme");
        }
        return scheme;
    }

    public static String getBasePath(MuleMessage message) {
        String basePath = (String)message.getInboundProperty("http.context.path");
        if (basePath == null) {
            String requestPath;
            String listenerPath = (String)message.getInboundProperty("http.listener.path");
            if (listenerPath.contains(requestPath = (String)message.getInboundProperty("http.request.path"))) {
                return requestPath;
            }
            int slashCount = StringUtils.countMatches((String)listenerPath, (String)"/");
            int matchPrefixIndex = StringUtils.ordinalIndexOf((String)requestPath, (String)"/", (int)slashCount);
            basePath = requestPath.substring(0, matchPrefixIndex);
        }
        return basePath;
    }
}

