/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.DefaultMuleMessage;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.processor.CloneableMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.cxf.CxfPayloadToArguments;
import org.mule.module.cxf.i18n.CxfMessages;
import org.mule.module.cxf.security.WebServiceSecurityException;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.TemplateParser;

public class CxfOutboundMessageProcessor
extends AbstractInterceptingMessageProcessor
implements CloneableMessageProcessor,
NonBlockingSupported {
    private static final String URI_REGEX = "cxf:\\[(.+?)\\]:(.+?)/\\[(.+?)\\]:(.+?)";
    Pattern URI_PATTERN = Pattern.compile("cxf:\\[(.+?)\\]:(.+?)/\\[(.+?)\\]:(.+?)");
    private final TemplateParser soapActionTemplateParser = TemplateParser.createMuleStyleParser();
    private CxfPayloadToArguments payloadToArguments = CxfPayloadToArguments.NULL_PAYLOAD_AS_PARAMETER;
    private Client client;
    private boolean proxy;
    private String operation;
    private BindingProvider clientProxy;
    private String decoupledEndpoint;
    private String mimeType;

    public CxfOutboundMessageProcessor(Client client) {
        this.client = client;
    }

    protected void cleanup() {
        Map requestContext = this.client.getRequestContext();
        requestContext.clear();
        Map responseContext = this.client.getResponseContext();
        responseContext.clear();
    }

    protected Object[] getArgs(MuleEvent event) throws TransformerException {
        Object payload = event.getMessage().getPayload();
        if (this.proxy) {
            return new Object[]{event.getMessage()};
        }
        Object[] args = this.payloadToArguments.payloadToArrayOfArguments(payload);
        MuleMessage message = event.getMessage();
        Set attachmentNames = message.getInboundAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty()) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            for (Object attachmentName : attachmentNames) {
                attachments.add(message.getInboundAttachment((String)attachmentName));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[attachments.size()]));
            args = temp.toArray();
        }
        if (args.length == 0) {
            return null;
        }
        return args;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            MuleEvent res = !this.isClientProxyAvailable() ? this.doSendWithClient(event) : this.doSendWithProxy(event);
            MuleEvent muleEvent = res;
            return muleEvent;
        }
        catch (Exception e) {
            throw this.wrapException(event, e, false);
        }
        finally {
            this.cleanup();
        }
    }

    private MuleException wrapException(MuleEvent event, Throwable ex, boolean alwaysReturnMessagingException) {
        if (ex instanceof MessagingException) {
            return (MessagingException)ex;
        }
        if (ex instanceof Fault) {
            Fault fault = (Fault)ex;
            if (fault.getCause() instanceof MuleException) {
                MuleException muleException = (MuleException)fault.getCause();
                return alwaysReturnMessagingException ? new MessagingException(event, (Throwable)muleException, (MessageProcessor)this) : muleException;
            }
            return new DispatchException(MessageFactory.createStaticMessage((String)fault.getMessage()), event, (MessageProcessor)this, (Throwable)fault);
        }
        return new DispatchException(MessageFactory.createStaticMessage((String)ExceptionHelper.getRootException((Throwable)ex).getMessage()), event, (MessageProcessor)this, ex);
    }

    private MessagingException wrapException(MuleEvent event, Throwable ex) {
        return (MessagingException)this.wrapException(event, ex, true);
    }

    public MuleEvent processNext(MuleEvent event) throws MuleException {
        return super.processNext(event);
    }

    protected MuleEvent doSendWithProxy(MuleEvent event) throws Exception {
        Object response;
        Method method = this.getMethod(event);
        Map<String, Object> props = this.getInovcationProperties(event);
        Holder responseHolder = new Holder();
        props.put("holder", responseHolder);
        String soapAction = (String)event.getMessage().getOutboundProperty("soapAction");
        if (soapAction != null) {
            props.put("SOAPAction", soapAction);
        }
        this.clientProxy.getRequestContext().putAll(props);
        Object[] args = this.getArgs(event);
        try {
            response = method.invoke((Object)this.clientProxy, args);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            if (ex != null && ex.getMessage().contains("Security")) {
                throw new WebServiceSecurityException(event, e, (MessageProcessor)this);
            }
            throw e;
        }
        Object[] objResponse = this.addHoldersToResponse(response, args);
        MuleEvent muleRes = (MuleEvent)responseHolder.value;
        if (event.isAllowNonBlocking()) {
            ((DefaultMuleMessage)muleRes.getMessage()).resetAccessControl();
        }
        return this.buildResponseMessage(event, muleRes, objResponse);
    }

    protected MuleEvent doSendWithClient(final MuleEvent event) throws Exception {
        BindingOperationInfo bop = this.getOperation(event);
        Map<String, Object> props = this.getInovcationProperties(event);
        final Holder responseHolder = new Holder();
        props.put("holder", responseHolder);
        HashMap<String, Map<String, Object>> ctx = new HashMap<String, Map<String, Object>>();
        ctx.put("RequestContext", props);
        ctx.put("ResponseContext", props);
        Object[] arr = event.getMessage().getPropertyNames().toArray();
        for (int i = 0; i < arr.length; ++i) {
            String head = (String)arr[i];
            if (head == null || head.startsWith("MULE")) continue;
            props.put((String)arr[i], event.getMessage().getProperty((String)arr[i]));
        }
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        if (event.isAllowNonBlocking() && event.getReplyToHandler() != null) {
            this.client.invoke(new ClientCallback(){

                public void handleResponse(Map<String, Object> ctx, Object[] res) {
                    try {
                        event.getReplyToHandler().processReplyTo(CxfOutboundMessageProcessor.this.buildResponseMessage(event, (MuleEvent)responseHolder.value, res), null, null);
                    }
                    catch (MuleException ex) {
                        this.handleException(ctx, ex);
                    }
                }

                public void handleException(Map<String, Object> ctx, Throwable ex) {
                    event.getReplyToHandler().processExceptionReplyTo(CxfOutboundMessageProcessor.this.wrapException((MuleEvent)responseHolder.value, ex), null);
                }
            }, bop, this.getArgs(event), ctx, (Exchange)exchange);
            return NonBlockingVoidMuleEvent.getInstance();
        }
        Object[] response = this.client.invoke(bop, this.getArgs(event), ctx, (Exchange)exchange);
        return this.buildResponseMessage(event, (MuleEvent)responseHolder.value, response);
    }

    public Method getMethod(MuleEvent event) throws Exception {
        Method method = null;
        String opName = (String)event.getMessage().getProperty("operation");
        if (opName != null) {
            method = this.getMethodFromOperation(opName);
        }
        if (method == null && (opName = this.operation) != null) {
            method = this.getMethodFromOperation(opName);
        }
        if (method == null) {
            throw new MessagingException(CxfMessages.noOperationWasFoundOrSpecified(), event, (MessageProcessor)this);
        }
        return method;
    }

    protected BindingOperationInfo getOperation(String opName) throws Exception {
        Endpoint ep = this.client.getEndpoint();
        BindingOperationInfo bop = this.getBindingOperationFromEndpoint(ep, opName);
        if (bop == null && (bop = this.tryToGetTheOperationInDotNetNamingConvention(ep, opName)) == null) {
            throw new Exception("No such operation: " + opName);
        }
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    protected BindingOperationInfo tryToGetTheOperationInDotNetNamingConvention(Endpoint ep, String opName) {
        String capitalizedOpName = opName.substring(0, 1).toUpperCase() + opName.substring(1);
        return this.getBindingOperationFromEndpoint(ep, capitalizedOpName);
    }

    protected BindingOperationInfo getBindingOperationFromEndpoint(Endpoint ep, String operationName) {
        QName q = new QName(ep.getService().getName().getNamespaceURI(), operationName);
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        return bop;
    }

    private Method getMethodFromOperation(String op) throws Exception {
        BindingOperationInfo bop = this.getOperation(op);
        MethodDispatcher md = (MethodDispatcher)this.client.getEndpoint().getService().get((Object)MethodDispatcher.class.getName());
        return md.getMethod(bop);
    }

    protected String getMethodOrOperationName(MuleEvent event) throws DispatchException {
        Object muleMethodProperty;
        String method = (String)event.getMessage().getInvocationProperty("operation");
        if (method == null && (muleMethodProperty = event.getMessage().getInvocationProperty("method")) != null) {
            method = muleMethodProperty instanceof Method ? ((Method)muleMethodProperty).getName() : muleMethodProperty.toString();
        }
        if (method == null) {
            method = this.operation;
        }
        if (method == null && this.proxy) {
            return "invoke";
        }
        return method;
    }

    public BindingOperationInfo getOperation(MuleEvent event) throws Exception {
        String opName = this.getMethodOrOperationName(event);
        if (opName == null) {
            opName = this.operation;
        }
        return this.getOperation(opName);
    }

    private Map<String, Object> getInovcationProperties(MuleEvent event) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("mule.event", event);
        props.put("cxf_outbound_message_processor", (Object)this);
        if (this.decoupledEndpoint != null) {
            props.put("org.apache.cxf.ws.addressing.replyto", this.decoupledEndpoint);
        }
        return props;
    }

    protected MuleEvent buildResponseMessage(MuleEvent request, MuleEvent transportResponse, Object[] response) {
        if (transportResponse == null) {
            return null;
        }
        if (VoidMuleEvent.getInstance().equals(transportResponse)) {
            return transportResponse;
        }
        Object payload = response == null || response.length == 0 ? null : (response.length == 1 ? response[0] : response);
        MuleMessage message = transportResponse.getMessage();
        Object httpStatusCode = message.getInboundProperty("http.status");
        if (this.isProxy() && httpStatusCode != null) {
            message.setOutboundProperty("http.status", httpStatusCode);
        }
        Class payloadClass = payload != null ? payload.getClass() : Object.class;
        message.setPayload(payload, DataTypeFactory.create(payloadClass, (String)this.getMimeType()));
        return transportResponse;
    }

    protected Object[] addHoldersToResponse(Object response, Object[] args) {
        ArrayList<Object> responseWithHolders = new ArrayList<Object>();
        responseWithHolders.add(response);
        if (args != null) {
            for (Object arg : args) {
                if (!(arg instanceof Holder)) continue;
                responseWithHolders.add(arg);
            }
        }
        return responseWithHolders.toArray();
    }

    public void setPayloadToArguments(CxfPayloadToArguments payloadToArguments) {
        this.payloadToArguments = payloadToArguments;
    }

    protected boolean isClientProxyAvailable() {
        return this.clientProxy != null;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setClientProxy(BindingProvider clientProxy) {
        this.clientProxy = clientProxy;
    }

    public CxfPayloadToArguments getPayloadToArguments() {
        return this.payloadToArguments;
    }

    public Client getClient() {
        return this.client;
    }

    public void setDecoupledEndpoint(String decoupledEndpoint) {
        this.decoupledEndpoint = decoupledEndpoint;
    }

    public MessageProcessor clone() {
        CxfOutboundMessageProcessor clone = new CxfOutboundMessageProcessor(this.client);
        clone.payloadToArguments = this.payloadToArguments;
        clone.proxy = this.proxy;
        clone.operation = this.operation;
        clone.clientProxy = this.clientProxy;
        clone.decoupledEndpoint = this.decoupledEndpoint;
        return clone;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

