/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.mule.api.MuleEvent;
import org.mule.module.cxf.support.AbstractProxyGZIPInterceptor;

public class ProxyGZIPInInterceptor
extends AbstractProxyGZIPInterceptor {
    public ProxyGZIPInInterceptor() {
        super("receive");
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"mule.event");
        if (event == null || event.getMessage() == null) {
            return;
        }
        if (this.isEncoded(event.getMessage())) {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is == null) {
                return;
            }
            try {
                GZIPInputStream zipInput = new GZIPInputStream(is);
                message.setContent(InputStream.class, (Object)zipInput);
            }
            catch (IOException io) {
                throw new Fault((Throwable)io);
            }
        }
    }
}

