/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.MessageObserver;
import org.mule.api.endpoint.EndpointNotFoundException;

public final class CxfUtils {
    public static boolean removeInterceptor(List<Interceptor<? extends Message>> inInterceptors, String name) {
        for (Interceptor<? extends Message> i : inInterceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getId().equals(name)) continue;
            inInterceptors.remove(p);
            return true;
        }
        return false;
    }

    public static Endpoint getEndpoint(DestinationFactory df, String uri) throws IOException, EndpointNotFoundException {
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        Destination d = df.getDestination(ei);
        if (d.getMessageObserver() == null) {
            throw new EndpointNotFoundException(uri);
        }
        MessageObserver mo = d.getMessageObserver();
        if (!(mo instanceof ChainInitiationObserver)) {
            throw new EndpointNotFoundException(uri);
        }
        ChainInitiationObserver co = (ChainInitiationObserver)mo;
        return co.getEndpoint();
    }

    public static String getBindingIdForSoapVersion(String version) {
        Iterator soapVersions = SoapVersionFactory.getInstance().getVersions();
        while (soapVersions.hasNext()) {
            SoapVersion soapVersion = (SoapVersion)soapVersions.next();
            if (!Double.toString(soapVersion.getVersion()).equals(version)) continue;
            return soapVersion.getBindingId();
        }
        throw new IllegalArgumentException("Invalid Soap version " + version);
    }
}

