/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.wsdl.http.AddressType;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.message.DefaultExceptionPayload;
import org.mule.module.cxf.support.DelegatingOutputStream;
import org.mule.module.xml.stax.StaxSource;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CxfInboundMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Lifecycle {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Bus bus;
    protected String transportClass;
    protected Server server;
    private boolean proxy;

    public void initialise() throws InitialisationException {
        if (this.bus == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No CXF bus instance, this component has not been initialized properly."), (Initialisable)this);
        }
        if (this.server == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No CXF Server instance, this component has not been initialized properly."), (Initialisable)this);
        }
    }

    public void stop() throws MuleException {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void start() throws MuleException {
        this.server.start();
    }

    public void dispose() {
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        String requestPath = this.parseHttpRequestProperty((String)event.getMessage().getInboundProperty("http.request", (Object)""));
        try {
            if (requestPath.indexOf(63) > -1) {
                return this.generateWSDLOrXSD(event, requestPath);
            }
            return this.sendToDestination(event);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private String parseHttpRequestProperty(String request) {
        String uriBase = "";
        if (!request.contains("?wsdl") && !request.contains("?xsd")) {
            int qIdx = request.indexOf(63);
            if (qIdx > -1) {
                uriBase = request.substring(0, qIdx);
            }
        } else {
            uriBase = request;
        }
        return uriBase;
    }

    protected MuleEvent generateWSDLOrXSD(MuleEvent event, String req) throws EndpointNotFoundException, IOException {
        String msg;
        String ctxUri = (String)event.getMessage().getInboundProperty("http.context.path");
        String wsdlUri = this.getWsdlUri(event, req);
        String serviceUri = wsdlUri.substring(0, wsdlUri.indexOf(63));
        EndpointInfo ei = this.getServer().getEndpoint().getEndpointInfo();
        if (serviceUri != null) {
            ei.setAddress(serviceUri);
            if (ei.getExtensor(AddressType.class) != null) {
                ((AddressType)ei.getExtensor(AddressType.class)).setLocation(serviceUri);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String ct = null;
        for (QueryHandler qh : ((QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
            if (!qh.isRecognizedQuery(wsdlUri, ctxUri, ei)) continue;
            ct = qh.getResponseContentType(wsdlUri, ctxUri);
            qh.writeResponse(wsdlUri, ctxUri, ei, (OutputStream)out);
            out.flush();
        }
        if (ct == null) {
            ct = "text/plain";
            msg = "No query handler found for URL.";
        } else {
            msg = out.toString();
        }
        event.getMessage().setPayload((Object)msg);
        event.getMessage().setProperty("Content-Type", (Object)ct);
        return event;
    }

    private String getWsdlUri(MuleEvent event, String reqPath) {
        EndpointURI epUri = event.getEndpoint().getEndpointURI();
        String host = (String)event.getMessage().getInboundProperty("Host", (Object)epUri.getHost());
        String ctx = (String)event.getMessage().getInboundProperty("http.request");
        return epUri.getScheme() + "://" + host + ctx;
    }

    protected MuleEvent sendToDestination(MuleEvent event) throws MuleException, IOException {
        try {
            Exception ex;
            String path;
            MessageImpl m = new MessageImpl();
            MuleMessage muleReqMsg = event.getMessage();
            String method = (String)muleReqMsg.getInboundProperty("http.method");
            String ct = (String)muleReqMsg.getInboundProperty("Content-Type");
            if (ct != null) {
                m.put((Object)"Content-Type", (Object)ct);
            }
            if ((path = (String)muleReqMsg.getInboundProperty("http.request.path")) == null) {
                path = "";
            }
            if (method != null) {
                m.put((Object)Message.HTTP_REQUEST_METHOD, (Object)method);
                m.put((Object)Message.PATH_INFO, (Object)path);
                Object basePath = muleReqMsg.getInboundProperty("http.context.path");
                m.put((Object)Message.BASE_PATH, basePath);
                method = method.toUpperCase();
            }
            if (!"GET".equals(method)) {
                Object payload = event.getMessage().getPayload();
                this.setPayload(event, m, payload);
            }
            String soapAction = this.getSoapAction(event.getMessage());
            m.put((Object)"SOAPAction", (Object)soapAction);
            Destination d = this.server.getDestination();
            m.put((Object)LocalConduit.DIRECT_DISPATCH, (Object)Boolean.TRUE);
            m.put((Object)"MULE_EVENT", (Object)RequestContext.getEvent());
            m.setDestination(d);
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setInMessage((Message)m);
            m.put((Object)"mule.event", (Object)event);
            exchange.put((Object)"mule.event", (Object)event);
            d.getMessageObserver().onMessage((Message)m);
            MuleEvent responseEvent = (MuleEvent)exchange.get((Object)"mule.event");
            if (responseEvent == null || !event.getEndpoint().getExchangePattern().hasResponse()) {
                return null;
            }
            MuleMessage muleResMsg = responseEvent.getMessage();
            muleResMsg.setPayload((Object)this.getRessponseOutputHandler(m));
            Message faultMsg = m.getExchange().getOutFaultMessage();
            if (faultMsg != null && (ex = (Exception)faultMsg.getContent(Exception.class)) != null) {
                DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload((Throwable)new Exception(""));
                event.getMessage().setExceptionPayload((ExceptionPayload)exceptionPayload);
                muleResMsg.setOutboundProperty("http.status", (Object)500);
            }
            return responseEvent;
        }
        catch (MuleException e) {
            this.logger.warn((Object)"Could not dispatch message to CXF!", (Throwable)e);
            throw e;
        }
    }

    public MuleEvent processNext(MuleEvent event) throws MuleException {
        return this.next.process(event);
    }

    protected OutputHandler getRessponseOutputHandler(final MessageImpl m) {
        OutputHandler outputHandler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                Message outFaultMessage = m.getExchange().getOutFaultMessage();
                Message outMessage = m.getExchange().getOutMessage();
                Message contentMsg = null;
                if (outFaultMessage != null && outFaultMessage.getContent(OutputStream.class) != null) {
                    contentMsg = outFaultMessage;
                } else if (outMessage != null) {
                    contentMsg = outMessage;
                }
                if (contentMsg == null) {
                    return;
                }
                DelegatingOutputStream delegate = (DelegatingOutputStream)contentMsg.getContent(DelegatingOutputStream.class);
                out.write(((ByteArrayOutputStream)delegate.getOutputStream()).toByteArray());
                delegate.setOutputStream(out);
                out.flush();
                contentMsg.getInterceptorChain().resume();
            }
        };
        return outputHandler;
    }

    private void setPayload(MuleEvent ctx, MessageImpl m, Object payload) throws TransformerException {
        if (payload instanceof InputStream) {
            m.put((Object)Message.ENCODING, (Object)ctx.getEncoding());
            m.setContent(InputStream.class, payload);
        } else if (payload instanceof Reader) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Reader)((Reader)payload)));
        } else if (payload instanceof byte[]) {
            m.setContent(InputStream.class, (Object)new ByteArrayInputStream((byte[])payload));
        } else if (payload instanceof StaxSource) {
            m.setContent(XMLStreamReader.class, (Object)((StaxSource)payload).getXMLStreamReader());
        } else if (payload instanceof Source) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)((Source)payload)));
        } else if (payload instanceof XMLStreamReader) {
            m.setContent(XMLStreamReader.class, payload);
        } else if (payload instanceof Document) {
            DOMSource source = new DOMSource((Node)payload);
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)source));
        } else {
            InputStream is = (InputStream)ctx.transformMessage(DataTypeFactory.create(InputStream.class));
            m.put((Object)Message.ENCODING, (Object)ctx.getEncoding());
            m.setContent(InputStream.class, (Object)is);
        }
    }

    protected InputStream getMessageStream(MuleEvent context) throws MuleException {
        Object eventMsgPayload = context.getMessage().getPayload();
        InputStream is = eventMsgPayload instanceof InputStream ? (InputStream)eventMsgPayload : (InputStream)context.transformMessage(DataTypeFactory.create(InputStream.class));
        return is;
    }

    protected String getSoapAction(MuleMessage message) {
        String action = (String)message.getInboundProperty("soapAction");
        if (action != null && action.startsWith("\"") && action.endsWith("\"") && action.length() >= 2) {
            action = action.substring(1, action.length() - 1);
        }
        return action;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }
}

