
package org.mule.modules.coupa.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/coupa</code>.
 * 
 */
public class CoupaModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new CoupaModuleConfigDefinitionParser());
        registerBeanDefinitionParser("save", new SaveDefinitionParser());
        registerBeanDefinitionParser("find-by-id", new FindByIdDefinitionParser());
        registerBeanDefinitionParser("find", new FindDefinitionParser());
        registerBeanDefinitionParser("find-by-example", new FindByExampleDefinitionParser());
    }

}
