/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.lang.tuple.Tuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Triple<T1, T2, T3>
extends Tuple
implements Comparable<Triple<T1, T2, T3>>,
Tuple.FirstAware<T1>,
Tuple.SecondAware<T2>,
Tuple.ThirdAware<T3> {
    private static final long serialVersionUID = 5811264763831754560L;
    private static final RelevantState<Triple> VAL = new Tuple.TupleState<Triple>(3){

        @Override
        protected void collectState(Triple o, RelevantState.StateCollector b) {
            b.add(o.first).add(o.second).add(o.third);
        }
    };
    private final T1 first;
    private final T2 second;
    private final T3 third;

    public Triple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public T1 first() {
        return this.first;
    }

    @Override
    public T2 second() {
        return this.second;
    }

    @Override
    public T3 third() {
        return this.third;
    }

    @Override
    public T1 _0() {
        return this.first();
    }

    @Override
    public T2 _1() {
        return this.second();
    }

    @Override
    public T3 _2() {
        return this.third();
    }

    @NonNull
    public Triple<T2, T3, T1> rotateLeft() {
        return new Triple<T2, T3, T1>(this.second, this.third, this.first);
    }

    @NonNull
    public Triple<T3, T1, T2> rotateRight() {
        return new Triple<T3, T1, T2>(this.third, this.first, this.second);
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second, this.third};
    }

    public int hashCode() {
        return VAL.hashCode(this);
    }

    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }

    @Override
    public int compareTo(Triple<T1, T2, T3> other) {
        return VAL.compareTo(this, other);
    }
}

