/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.number;

import java.io.Serializable;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.restrictions.Constant;

public abstract class AbstractNumberType<A extends Number>
implements NumberType<A>,
Serializable {
    private static final long serialVersionUID = -2727245678088637829L;
    private final AbstractFunction2 add = this.addInitializer();
    private final AbstractFunction2 multiply = this.multiplyInitializer();
    private final Function negate = this.negateInitializer();
    private final Function abs = this.absInitializer();
    private final Function inverse = this.inverseInitializer();

    public boolean isZero(A n) {
        return this.compare(n, (A)((Number)this.zero())) == 0;
    }

    public boolean isNegative(A n) {
        return this.compare(n, (A)((Number)this.zero())) < 0;
    }

    public boolean isPositive(A n) {
        return this.compare(n, (A)((Number)this.zero())) > 0;
    }

    public A subtract(A n0, A n1) {
        return (A)((Number)this.add(n0, (Number)this.negate(n1)));
    }

    public int compare(A o1, A o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    public A increment(A n) {
        return (A)((Number)this.add(n, (Number)this.one()));
    }

    public A decrement(A n) {
        return (A)this.subtract(n, (A)((Number)this.one()));
    }

    public A abs(A n) {
        return (A)(this.isNegative(n) ? (Number)this.negate(n) : n);
    }

    @Constant
    public AbstractFunction2<A, A, A> add() {
        return this.add;
    }

    @Constant
    public AbstractFunction2<A, A, A> multiply() {
        return this.multiply;
    }

    public Function<A, A> add(A n) {
        return this.add().apply(n);
    }

    public A inverse(A n) {
        return (A)((Number)this.divide((Number)this.one(), n));
    }

    @Constant
    public Function<A, A> negate() {
        return this.negate;
    }

    @Constant
    public Function<A, A> abs() {
        return this.abs;
    }

    @Constant
    public Function<A, A> inverse() {
        return this.inverse;
    }

    private AbstractFunction2 addInitializer() {
        return new AbstractFunction2<A, A, A>(){

            public A apply(A arg0, A arg1) {
                return (Number)AbstractNumberType.this.add(arg0, arg1);
            }
        };
    }

    private AbstractFunction2 multiplyInitializer() {
        return new Multiply(this);
    }

    private Function negateInitializer() {
        return new AbstractFunction<A, A>(){

            public A apply(A arg) {
                return AbstractNumberType.this.inverse(arg);
            }
        };
    }

    private Function absInitializer() {
        return new AbstractFunction<A, A>(){

            public A apply(A arg) {
                return AbstractNumberType.this.abs(arg);
            }
        };
    }

    private Function inverseInitializer() {
        return new AbstractFunction<A, A>(){

            public A apply(A arg) {
                return AbstractNumberType.this.inverse(arg);
            }
        };
    }

    private static final class Multiply<A>
    extends NumberTypeFunction2<A> {
        public Multiply(NumberType<A> type) {
            super(type);
        }

        public A apply(A arg0, A arg1) {
            return (A)this.numberType().multiply(arg0, arg1);
        }
    }

    private static abstract class NumberTypeFunction2<A>
    extends AbstractFunction2<A, A, A> {
        private NumberType<A> numberType;

        public NumberTypeFunction2(NumberType<A> type) {
            this.numberType = type;
        }

        public NumberType<A> numberType() {
            return this.numberType;
        }
    }
}

