/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.lifecycle;

import java.util.concurrent.Callable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.lang.Handle;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class Lifecycle<ResourceType, ResultType>
implements Thunk<ResultType>,
Callable<ResultType> {
    @Override
    public ResultType call() throws Exception {
        ResourceType resource = null;
        try {
            resource = this.initialize();
            ResultType ResultType = this.doWork(resource);
            return ResultType;
        }
        finally {
            if (resource != null) {
                this.dispose(resource);
            }
        }
    }

    public ResultType value() {
        return (ResultType)SoftException.callOrSoften(this);
    }

    public final <E extends Exception> ResultType throwing(Class<E> exceptionClass) throws E {
        return (ResultType)Handle.throwing(this, exceptionClass);
    }

    public final <E1 extends Exception, E2 extends Exception> ResultType throwing(Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2 {
        return (ResultType)Handle.throwing(this, exceptionClass1, exceptionClass2);
    }

    protected abstract ResourceType initialize() throws Exception;

    protected ResultType doWork(@NonNull ResourceType resource) throws Exception {
        this.doVoidWork(resource);
        return null;
    }

    protected void doVoidWork(@NonNull ResourceType resource) throws Exception {
    }

    protected void dispose(@NonNull ResourceType resource) throws Exception {
    }
}

