/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.defs.ContainsAware;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.SizeAware;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.lang.None;
import net.sf.staccatocommons.lang.Some;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class Option<T>
implements Thunk<T>,
Iterable<T>,
SizeAware,
ContainsAware<T>,
Serializable {
    private static final long serialVersionUID = -4635925023376621559L;

    Option() {
    }

    public abstract T value() throws NoSuchElementException;

    public abstract boolean isDefined();

    public boolean isUndefined() {
        return !this.isDefined();
    }

    @Constant
    public static <T> None<T> none() {
        return None.none();
    }

    public abstract T valueOrElse(T var1);

    public abstract T valueOrElse(Thunk<? extends T> var1);

    public abstract T valueOrNull();

    public abstract void ifDefined(@NonNull Executable<T> var1);

    public static <T> Some<T> some(T value) {
        return Some.some(value);
    }

    public static <T> Some<T> someNull() {
        return Some.someNull();
    }

    public static <T> Option<T> nullToNone(T value) {
        if (value == null) {
            return Option.none();
        }
        return Option.some(value);
    }
}

