/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.check.format;

public class VariableFormatter {
    private static final String FORMATTING_STRING_REGEXP = ".*\\%s.*\\%s.*";
    public static final String DEFAULT_FORMATTING_STRING = "%s=[%s]";
    private final String formattingString;
    private final String formattingWithPrefixString;
    private final String formattingWithPrefixAndSuffixString;
    private final String formattingWithSuffixString;

    public VariableFormatter(String formattingString) {
        if (!formattingString.equals(DEFAULT_FORMATTING_STRING) && !formattingString.matches(FORMATTING_STRING_REGEXP)) {
            throw new IllegalArgumentException("Formatting string must match regex .*\\%s.*\\%s.*");
        }
        this.formattingString = formattingString;
        this.formattingWithPrefixString = this.createFormattingWithPrefixString();
        this.formattingWithPrefixAndSuffixString = this.createFormattingWithPrefixAndSuffixString();
        this.formattingWithSuffixString = this.createFormattingWithSuffixString();
    }

    public VariableFormatter() {
        this(DEFAULT_FORMATTING_STRING);
    }

    private String createFormattingWithPrefixString() {
        return "%s " + this.getFormattingString();
    }

    private String createFormattingWithPrefixAndSuffixString() {
        return "%s " + this.getFormattingString() + " %s";
    }

    private String createFormattingWithSuffixString() {
        return String.valueOf(this.getFormattingString()) + " %s";
    }

    public String format(String name, Object value) {
        return String.format(this.getFormattingString(), name, value);
    }

    public String format(String prefix, String name, Object value) {
        return String.format(this.getFormattingWithPrefixString(), prefix, name, value);
    }

    public String format(String name, Object value, String suffix) {
        return String.format(this.getFormattingWithSuffixString(), name, value, suffix);
    }

    public String format(String prefix, String name, Object value, String suffix) {
        return String.format(this.getFormattingWithPrefixAndSuffixString(), prefix, name, value, suffix);
    }

    private String getFormattingString() {
        return this.formattingString;
    }

    private String getFormattingWithPrefixString() {
        return this.formattingWithPrefixString;
    }

    private String getFormattingWithSuffixString() {
        return this.formattingWithSuffixString;
    }

    private String getFormattingWithPrefixAndSuffixString() {
        return this.formattingWithPrefixAndSuffixString;
    }
}

