/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl.internal;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.EmptyAware;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.lang.thunk.Thunks;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;
import org.apache.commons.lang.StringUtils;

public class SingleLinkedDelayedQueue<A>
implements Iterable<A>,
EmptyAware {
    private final Cell<A> head = new Cell(Thunks.undefined());
    private Cell<A> last = this.head;

    @ForceRestrictions
    public void add(@NonNull Thunk<A> element) {
        Ensure.isNotNull((String)"var0", element);
        Cell<A> prev = this.last;
        this.last = new Cell<A>(element);
        ((Cell)prev).next = (Cell)this.last;
    }

    @Override
    public Thriterator<A> iterator() {
        return new Iter<A>(this.head);
    }

    public boolean isEmpty() {
        return !this.head.hasNext();
    }

    public String toString() {
        return "[" + StringUtils.join(this.iterator(), (String)",") + "]";
    }

    private static final class Cell<A> {
        private final Thunk<A> element;
        private Cell<A> next;

        public Cell(Thunk<A> element) {
            this.element = element;
        }

        boolean hasNext() {
            return this.next != null;
        }
    }

    private static final class Iter<A>
    extends AdvanceThriterator<A> {
        private Cell<A> current;

        public Iter(Cell<A> current) {
            this.current = current;
        }

        public boolean hasNext() {
            return this.current.hasNext();
        }

        public void advanceNext() throws NoSuchElementException {
            this.current = ((Cell)this.current).next;
        }

        public A current() {
            return (A)this.delayedCurrent().value();
        }

        public Thunk<A> delayedCurrent() {
            return ((Cell)this.current).element;
        }
    }
}

