/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl.internal;

import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.impl.internal.AbstractAppendStream;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.iterators.AppendThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.lang.predicate.Equiv;

public class AppendStream<A>
extends AbstractAppendStream<A> {
    private final A element;

    public AppendStream(Stream<A> source, A element) {
        super(source);
        this.element = element;
    }

    @Override
    public Thriterator<A> iterator() {
        return new AppendThriterator(this.getSource().iterator(), this.element);
    }

    @Override
    public boolean all(Evaluable<? super A> predicate) {
        return this.getSource().all(predicate) && predicate.eval(this.element);
    }

    @Override
    public boolean any(Evaluable<? super A> predicate) {
        return this.getSource().any(predicate) || predicate.eval(this.element);
    }

    @Override
    public boolean contains(A element) {
        return this.getSource().contains(element) || Equiv.equalNullSafe().eval(element, this.element);
    }
}

