/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.internal.iterator;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class DropIterator<A>
extends AdvanceThriterator<A> {
    private int n;
    private final Thriter<A> thriter;

    public DropIterator(int n, @NonNull Thriter<A> thriter) {
        Ensure.isNotNull((String)"var1", thriter);
        this.n = n;
        this.thriter = thriter;
    }

    public boolean hasNext() {
        while (this.n > 0) {
            if (!this.thriter.hasNext()) {
                return false;
            }
            this.thriter.advanceNext();
            --this.n;
        }
        return this.thriter.hasNext();
    }

    public void advanceNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.thriter.advanceNext();
    }

    public A current() {
        return (A)this.thriter.current();
    }

    public Thunk<A> delayedCurrent() {
        return this.thriter.delayedCurrent();
    }
}

