/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;
import org.apache.commons.beanutils.PropertyUtils;

public final class StructureType {
    private StructureType() {
    }

    private static Type getType(Object bean, String propertyName) {
        PropertyDescriptor propertyDescriptor;
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)propertyName);
        }
        catch (Exception e) {
            throw SoftException.soften((Exception)e);
        }
        Ensure.that((propertyDescriptor != null ? 1 : 0) != 0, (String)"There is no property named %s in class %s", (Object[])new Object[]{propertyName, bean.getClass()});
        if (propertyDescriptor.getPropertyType() == Boolean.class) {
            return Boolean.class;
        }
        Method readMethod = propertyDescriptor.getReadMethod();
        Ensure.that((readMethod != null ? 1 : 0) != 0, (String)"Property %s in class %s is not readable", (Object[])new Object[]{propertyName, bean.getClass()});
        return readMethod.getGenericReturnType();
    }

    @ForceRestrictions
    public static Class getStructureType(@NonNull Object destination, @NotEmpty String propertyName) {
        ParameterizedType parameterizedType;
        Ensure.that().isNotEmpty("var1", (CharSequence)propertyName);
        Ensure.isNotNull((String)"var0", (Object)destination);
        Type targetType = StructureType.getType(destination, propertyName);
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        if (targetType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)targetType).getRawType() == List.class) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return (Class)Ensure.that().fail("Unsupported type %s for propertyName %s in object %s", new Object[]{targetType, propertyName, destination});
    }
}

